/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.CommonConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseReduceService {
    protected static final int QUERY_RUNNER_THREAD_PRIORITY = 7;
    protected static final String REDUCE_THREAD_NAME_FORMAT = "brw-%d";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseReduceService.class);
    protected final ExecutorService _reduceExecutorService;
    protected final int _maxReduceThreadsPerQuery;
    protected final int _groupByTrimThreshold;
    protected final int _minGroupTrimSize;

    public BaseReduceService(PinotConfiguration config) {
        this._maxReduceThreadsPerQuery = config.getProperty("pinot.broker.max.reduce.threads.per.query", CommonConstants.Broker.DEFAULT_MAX_REDUCE_THREADS_PER_QUERY);
        this._groupByTrimThreshold = config.getProperty("pinot.broker.groupby.trim.threshold", 1000000);
        this._minGroupTrimSize = config.getProperty("pinot.broker.min.group.trim.size", 5000);
        int numThreadsInExecutorService = Runtime.getRuntime().availableProcessors();
        LOGGER.info("Initializing BrokerReduceService with {} threads, and {} max reduce threads.", (Object)numThreadsInExecutorService, (Object)this._maxReduceThreadsPerQuery);
        ThreadFactory reduceThreadFactory = new ThreadFactoryBuilder().setDaemon(false).setPriority(7).setNameFormat(REDUCE_THREAD_NAME_FORMAT).build();
        this._reduceExecutorService = Executors.newFixedThreadPool(numThreadsInExecutorService, reduceThreadFactory);
    }

    protected static void updateAlias(QueryContext queryContext, BrokerResponseNative brokerResponseNative) {
        List<ExpressionContext> selectExpressions;
        int numSelectExpressions;
        ResultTable resultTable = brokerResponseNative.getResultTable();
        if (resultTable == null) {
            return;
        }
        List<String> aliasList = queryContext.getAliasList();
        if (aliasList.isEmpty()) {
            return;
        }
        String[] columnNames = resultTable.getDataSchema().getColumnNames();
        if (columnNames.length != (numSelectExpressions = (selectExpressions = BaseReduceService.getSelectExpressions(queryContext.getSelectExpressions())).size())) {
            return;
        }
        for (int i = 0; i < numSelectExpressions; ++i) {
            String alias = aliasList.get(i);
            if (alias == null) continue;
            columnNames[i] = alias;
        }
    }

    protected static List<ExpressionContext> getSelectExpressions(List<ExpressionContext> selectExpressions) {
        if (selectExpressions.size() == 1 && selectExpressions.get(0).getType() == ExpressionContext.Type.FUNCTION && selectExpressions.get(0).getFunction().getFunctionName().equals("distinct")) {
            return selectExpressions.get(0).getFunction().getArguments();
        }
        return selectExpressions;
    }

    protected void shutDown() {
        this._reduceExecutorService.shutdownNow();
    }
}

