/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.query.reduce.BaseGapfillProcessor;
import org.apache.pinot.core.query.reduce.BaseReduceService;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.ExecutionStatsAggregator;
import org.apache.pinot.core.query.reduce.GapfillProcessorFactory;
import org.apache.pinot.core.query.reduce.ResultReducerFactory;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextConverterUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.util.GapfillUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BrokerReduceService
extends BaseReduceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerReduceService.class);

    public BrokerReduceService(PinotConfiguration config) {
        super(config);
    }

    public BrokerResponseNative reduceOnDataTable(BrokerRequest brokerRequest, BrokerRequest serverBrokerRequest, Map<ServerRoutingInstance, DataTable> dataTableMap, long reduceTimeOutMs, BrokerMetrics brokerMetrics) {
        QueryContext queryContext;
        DataSchema cachedDataSchema;
        if (dataTableMap.isEmpty()) {
            return BrokerResponseNative.empty();
        }
        Map queryOptions = brokerRequest.getPinotQuery().getQueryOptions();
        boolean enableTrace = queryOptions != null && Boolean.parseBoolean((String)queryOptions.get("trace"));
        ExecutionStatsAggregator aggregator = new ExecutionStatsAggregator(enableTrace);
        BrokerResponseNative brokerResponseNative = new BrokerResponseNative();
        DataSchema dataSchemaFromEmptyDataTable = null;
        DataSchema dataSchemaFromNonEmptyDataTable = null;
        ArrayList<ServerRoutingInstance> serversWithConflictingDataSchema = new ArrayList<ServerRoutingInstance>();
        Iterator<Map.Entry<ServerRoutingInstance, DataTable>> iterator = dataTableMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ServerRoutingInstance, DataTable> entry = iterator.next();
            DataTable dataTable = entry.getValue();
            aggregator.aggregate(entry.getKey(), dataTable);
            DataSchema dataSchema = dataTable.getDataSchema();
            if (dataSchema == null) {
                iterator.remove();
                continue;
            }
            if (dataTable.getNumberOfRows() == 0) {
                if (dataSchemaFromEmptyDataTable == null) {
                    dataSchemaFromEmptyDataTable = dataSchema;
                }
                iterator.remove();
                continue;
            }
            if (dataSchemaFromNonEmptyDataTable == null) {
                dataSchemaFromNonEmptyDataTable = dataSchema;
                continue;
            }
            if (Arrays.equals(dataSchema.getColumnDataTypes(), dataSchemaFromNonEmptyDataTable.getColumnDataTypes())) continue;
            serversWithConflictingDataSchema.add(entry.getKey());
            iterator.remove();
        }
        String tableName = serverBrokerRequest.getQuerySource().getTableName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        aggregator.setStats(rawTableName, brokerResponseNative, brokerMetrics);
        if (!serversWithConflictingDataSchema.isEmpty()) {
            String errorMessage = String.format("%s: responses for table: %s from servers: %s got dropped due to data schema inconsistency.", QueryException.MERGE_RESPONSE_ERROR.getMessage(), tableName, serversWithConflictingDataSchema);
            LOGGER.warn(errorMessage);
            brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.RESPONSE_MERGE_EXCEPTIONS, 1L);
            brokerResponseNative.addException(new QueryProcessingException(500, errorMessage));
        }
        DataSchema dataSchema = cachedDataSchema = dataSchemaFromNonEmptyDataTable != null ? dataSchemaFromNonEmptyDataTable : dataSchemaFromEmptyDataTable;
        if (cachedDataSchema == null) {
            return brokerResponseNative;
        }
        QueryContext serverQueryContext = QueryContextConverterUtils.getQueryContext(serverBrokerRequest.getPinotQuery());
        DataTableReducer dataTableReducer = ResultReducerFactory.getResultReducer(serverQueryContext);
        Integer minGroupTrimSizeQueryOption = null;
        Integer groupTrimThresholdQueryOption = null;
        if (queryOptions != null) {
            minGroupTrimSizeQueryOption = QueryOptionsUtils.getMinBrokerGroupTrimSize((Map)queryOptions);
            groupTrimThresholdQueryOption = QueryOptionsUtils.getGroupTrimThreshold((Map)queryOptions);
        }
        int minGroupTrimSize = minGroupTrimSizeQueryOption != null ? minGroupTrimSizeQueryOption : this._minGroupTrimSize;
        int groupTrimThreshold = groupTrimThresholdQueryOption != null ? groupTrimThresholdQueryOption : this._groupByTrimThreshold;
        try {
            dataTableReducer.reduceAndSetResults(rawTableName, cachedDataSchema, dataTableMap, brokerResponseNative, new DataTableReducerContext(this._reduceExecutorService, this._maxReduceThreadsPerQuery, reduceTimeOutMs, groupTrimThreshold, minGroupTrimSize), brokerMetrics);
        }
        catch (EarlyTerminationException e) {
            brokerResponseNative.addException(new QueryProcessingException(503, e.toString()));
        }
        if (brokerRequest == serverBrokerRequest) {
            queryContext = serverQueryContext;
        } else {
            queryContext = QueryContextConverterUtils.getQueryContext(brokerRequest.getPinotQuery());
            GapfillUtils.GapfillType gapfillType = GapfillUtils.getGapfillType(queryContext);
            if (gapfillType == null) {
                throw new BadQueryRequestException("Nested query is not supported without gapfill");
            }
            BaseGapfillProcessor gapfillProcessor = GapfillProcessorFactory.getGapfillProcessor(queryContext, gapfillType);
            gapfillProcessor.process(brokerResponseNative);
        }
        if (!serverQueryContext.isExplain()) {
            BrokerReduceService.updateAlias(queryContext, brokerResponseNative);
        }
        return brokerResponseNative;
    }

    @Override
    public void shutDown() {
        this._reduceExecutorService.shutdownNow();
    }
}

