/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.ReducerDataSchemaUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.RoaringBitmap;

public class DistinctDataTableReducer
implements DataTableReducer {
    private final QueryContext _queryContext;

    public DistinctDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        DistinctTable distinctTable = new DistinctTable(dataSchema = ReducerDataSchemaUtils.canonicalizeDataSchemaForDistinct(this._queryContext, dataSchema), this._queryContext.getOrderByExpressions(), this._queryContext.getLimit(), this._queryContext.isNullHandlingEnabled());
        if (distinctTable.hasOrderBy()) {
            this.addToOrderByDistinctTable(dataSchema, dataTableMap, distinctTable);
        } else {
            this.addToNonOrderByDistinctTable(dataSchema, dataTableMap, distinctTable);
        }
        brokerResponseNative.setResultTable(this.reduceToResultTable(distinctTable));
    }

    private void addToOrderByDistinctTable(DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, DistinctTable distinctTable) {
        for (DataTable dataTable : dataTableMap.values()) {
            Tracing.ThreadAccountantOps.sampleAndCheckInterruption();
            int numColumns = dataSchema.size();
            int numRows = dataTable.getNumberOfRows();
            if (this._queryContext.isNullHandlingEnabled()) {
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
                for (int coldId = 0; coldId < numColumns; ++coldId) {
                    nullBitmaps[coldId] = dataTable.getNullRowIds(coldId);
                }
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    distinctTable.addWithOrderBy(new Record(SelectionOperatorUtils.extractRowFromDataTableWithNullHandling(dataTable, rowId, nullBitmaps)));
                }
                continue;
            }
            for (int rowId = 0; rowId < numRows; ++rowId) {
                distinctTable.addWithOrderBy(new Record(SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId)));
            }
        }
    }

    private void addToNonOrderByDistinctTable(DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, DistinctTable distinctTable) {
        for (DataTable dataTable : dataTableMap.values()) {
            Tracing.ThreadAccountantOps.sampleAndCheckInterruption();
            int numColumns = dataSchema.size();
            int numRows = dataTable.getNumberOfRows();
            if (this._queryContext.isNullHandlingEnabled()) {
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
                for (int coldId = 0; coldId < numColumns; ++coldId) {
                    nullBitmaps[coldId] = dataTable.getNullRowIds(coldId);
                }
                for (int rowId = 0; rowId < numRows; ++rowId) {
                    if (!distinctTable.addWithoutOrderBy(new Record(SelectionOperatorUtils.extractRowFromDataTableWithNullHandling(dataTable, rowId, nullBitmaps)))) continue;
                    return;
                }
                continue;
            }
            for (int rowId = 0; rowId < numRows; ++rowId) {
                if (!distinctTable.addWithoutOrderBy(new Record(SelectionOperatorUtils.extractRowFromDataTable(dataTable, rowId)))) continue;
                return;
            }
        }
    }

    private ResultTable reduceToResultTable(DistinctTable distinctTable) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(distinctTable.size());
        DataSchema dataSchema = distinctTable.getDataSchema();
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        Iterator<Record> iterator = distinctTable.getFinalResult();
        while (iterator.hasNext()) {
            Object[] values = iterator.next().getValues();
            Object[] row = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                Object value = values[i];
                if (value == null) continue;
                row[i] = columnDataTypes[i].convertAndFormat(value);
            }
            rows.add(row);
        }
        return new ResultTable(dataSchema, rows);
    }
}

