/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.common.CustomObject;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerGauge;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.data.table.ConcurrentIndexedTable;
import org.apache.pinot.core.data.table.IndexedTable;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.SimpleIndexedTable;
import org.apache.pinot.core.data.table.UnboundedConcurrentIndexedTable;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.HavingFilterHandler;
import org.apache.pinot.core.query.reduce.PostAggregationHandler;
import org.apache.pinot.core.query.reduce.ReducerDataSchemaUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.utils.rewriter.ResultRewriteUtils;
import org.apache.pinot.core.query.utils.rewriter.RewriterResult;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.core.util.trace.TraceRunnable;
import org.apache.pinot.spi.accounting.ThreadExecutionContext;
import org.apache.pinot.spi.accounting.ThreadResourceUsageProvider;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.RoaringBitmap;

public class GroupByDataTableReducer
implements DataTableReducer {
    private static final int MIN_DATA_TABLES_FOR_CONCURRENT_REDUCE = 2;
    private final QueryContext _queryContext;
    private final AggregationFunction[] _aggregationFunctions;
    private final int _numAggregationFunctions;
    private final int _numGroupByExpressions;
    private final int _numColumns;

    public GroupByDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        assert (this._aggregationFunctions != null);
        this._numAggregationFunctions = this._aggregationFunctions.length;
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        assert (groupByExpressions != null);
        this._numGroupByExpressions = groupByExpressions.size();
        this._numColumns = this._numAggregationFunctions + this._numGroupByExpressions;
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponse, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        dataSchema = ReducerDataSchemaUtils.canonicalizeDataSchemaForGroupBy(this._queryContext, dataSchema);
        if (dataTableMap.isEmpty()) {
            PostAggregationHandler postAggregationHandler = new PostAggregationHandler(this._queryContext, this.getPrePostAggregationDataSchema(dataSchema));
            DataSchema resultDataSchema = postAggregationHandler.getResultDataSchema();
            RewriterResult rewriterResult = ResultRewriteUtils.rewriteResult(resultDataSchema, Collections.emptyList());
            brokerResponse.setResultTable(new ResultTable(rewriterResult.getDataSchema(), rewriterResult.getRows()));
            return;
        }
        Collection<DataTable> dataTables = dataTableMap.values();
        if (this._queryContext.isServerReturnFinalResult() && dataTables.size() == 1) {
            this.processSingleFinalResult(dataSchema, dataTables.iterator().next(), brokerResponse);
        } else {
            try {
                this.reduceResult(brokerResponse, dataSchema, dataTables, reducerContext, tableName, brokerMetrics);
            }
            catch (TimeoutException e) {
                brokerResponse.getExceptions().add(new QueryProcessingException(400, e.getMessage()));
            }
        }
        if (brokerMetrics != null && brokerResponse.getResultTable() != null) {
            brokerMetrics.addMeteredTableValue(tableName, (AbstractMetrics.Meter)BrokerMeter.GROUP_BY_SIZE, (long)brokerResponse.getResultTable().getRows().size());
        }
    }

    private void reduceResult(BrokerResponseNative brokerResponseNative, DataSchema dataSchema, Collection<DataTable> dataTables, DataTableReducerContext reducerContext, String rawTableName, BrokerMetrics brokerMetrics) throws TimeoutException {
        ArrayList<Object[]> rows;
        IndexedTable indexedTable = this.getIndexedTable(dataSchema, dataTables, reducerContext);
        if (brokerMetrics != null) {
            brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.NUM_RESIZES, (long)indexedTable.getNumResizes());
            brokerMetrics.addValueToTableGauge(rawTableName, (AbstractMetrics.Gauge)BrokerGauge.RESIZE_TIME_MS, indexedTable.getResizeTimeMs());
        }
        int numRecords = indexedTable.size();
        Iterator<Record> sortedIterator = indexedTable.iterator();
        PostAggregationHandler postAggregationHandler = new PostAggregationHandler(this._queryContext, dataSchema);
        DataSchema resultDataSchema = postAggregationHandler.getResultDataSchema();
        int limit = this._queryContext.getLimit();
        if (numRecords == 0 || limit == 0) {
            brokerResponseNative.setResultTable(new ResultTable(resultDataSchema, Collections.emptyList()));
            return;
        }
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        FilterContext havingFilter = this._queryContext.getHavingFilter();
        if (havingFilter != null) {
            rows = new ArrayList<Object[]>();
            HavingFilterHandler havingFilterHandler = new HavingFilterHandler(havingFilter, postAggregationHandler, this._queryContext.isNullHandlingEnabled());
            int processedRows = 0;
            while (rows.size() < limit && sortedIterator.hasNext()) {
                Object[] row = sortedIterator.next().getValues();
                for (int i = 0; i < numColumns; ++i) {
                    Object value = row[i];
                    if (value == null) continue;
                    row[i] = columnDataTypes[i].convert(row[i]);
                }
                if (havingFilterHandler.isMatch(row)) {
                    rows.add(row);
                }
                Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)processedRows);
                ++processedRows;
            }
        } else {
            int numRows = Math.min(numRecords, limit);
            rows = new ArrayList(numRows);
            for (int i = 0; i < numRows; ++i) {
                Object[] row = sortedIterator.next().getValues();
                for (int j = 0; j < numColumns; ++j) {
                    Object value = row[j];
                    if (value == null) continue;
                    row[j] = columnDataTypes[j].convert(row[j]);
                }
                rows.add(row);
                Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)i);
            }
        }
        List<Object[]> resultRows = this.calculateFinalResultRows(postAggregationHandler, rows);
        RewriterResult rewriterResult = ResultRewriteUtils.rewriteResult(resultDataSchema, resultRows);
        brokerResponseNative.setResultTable(new ResultTable(rewriterResult.getDataSchema(), rewriterResult.getRows()));
    }

    private DataSchema getPrePostAggregationDataSchema(DataSchema dataSchema) {
        String[] columnNames = dataSchema.getColumnNames();
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[this._numColumns];
        System.arraycopy(dataSchema.getColumnDataTypes(), 0, columnDataTypes, 0, this._numGroupByExpressions);
        for (int i = 0; i < this._numAggregationFunctions; ++i) {
            columnDataTypes[i + this._numGroupByExpressions] = this._aggregationFunctions[i].getFinalResultColumnType();
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    private IndexedTable getIndexedTable(DataSchema dataSchema, Collection<DataTable> dataTablesToReduce, DataTableReducerContext reducerContext) throws TimeoutException {
        int i;
        long start = System.currentTimeMillis();
        int numDataTables = dataTablesToReduce.size();
        int numReduceThreadsToUse = this.getNumReduceThreadsToUse(numDataTables, reducerContext.getMaxReduceThreadsPerQuery());
        boolean hasFinalInput = this._queryContext.isServerReturnFinalResult() || this._queryContext.isServerReturnFinalResultKeyUnpartitioned();
        int limit = this._queryContext.getLimit();
        int trimSize = GroupByUtils.getTableCapacity(limit, reducerContext.getMinGroupTrimSize());
        int resultSize = this._queryContext.getHavingFilter() != null ? trimSize : limit;
        int trimThreshold = reducerContext.getGroupByTrimThreshold();
        final IndexedTable indexedTable = numReduceThreadsToUse == 1 ? new SimpleIndexedTable(dataSchema, hasFinalInput, this._queryContext, resultSize, trimSize, trimThreshold) : (trimThreshold >= 1000000000 ? new UnboundedConcurrentIndexedTable(dataSchema, hasFinalInput, this._queryContext, resultSize) : new ConcurrentIndexedTable(dataSchema, hasFinalInput, this._queryContext, resultSize, trimSize, trimThreshold));
        ArrayList<DataTable> dataTables = new ArrayList<DataTable>(dataTablesToReduce);
        ArrayList reduceGroups = new ArrayList(numReduceThreadsToUse);
        for (i = 0; i < numReduceThreadsToUse; ++i) {
            reduceGroups.add(new ArrayList());
        }
        for (i = 0; i < numDataTables; ++i) {
            ((List)reduceGroups.get(i % numReduceThreadsToUse)).add(dataTables.get(i));
        }
        Future[] futures = new Future[numReduceThreadsToUse];
        final CountDownLatch countDownLatch = new CountDownLatch(numReduceThreadsToUse);
        final AtomicReference exception = new AtomicReference();
        final DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        for (int i2 = 0; i2 < numReduceThreadsToUse; ++i2) {
            final List reduceGroup = (List)reduceGroups.get(i2);
            final int taskId = i2;
            final ThreadExecutionContext parentContext = Tracing.getThreadAccountant().getThreadExecutionContext();
            futures[i2] = reducerContext.getExecutorService().submit(new TraceRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runJob() {
                    Tracing.ThreadAccountantOps.setupWorker((int)taskId, (ThreadResourceUsageProvider)new ThreadResourceUsageProvider(), (ThreadExecutionContext)parentContext);
                    try {
                        for (DataTable dataTable : reduceGroup) {
                            boolean nullHandlingEnabled = GroupByDataTableReducer.this._queryContext.isNullHandlingEnabled();
                            RoaringBitmap[] nullBitmaps = null;
                            if (nullHandlingEnabled) {
                                nullBitmaps = new RoaringBitmap[GroupByDataTableReducer.this._numColumns];
                                for (int i = 0; i < GroupByDataTableReducer.this._numColumns; ++i) {
                                    nullBitmaps[i] = dataTable.getNullRowIds(i);
                                }
                            }
                            int numRows = dataTable.getNumberOfRows();
                            for (int rowId = 0; rowId < numRows; ++rowId) {
                                int colId;
                                Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)rowId);
                                Object[] values = new Object[GroupByDataTableReducer.this._numColumns];
                                block23: for (colId = 0; colId < GroupByDataTableReducer.this._numColumns; ++colId) {
                                    switch (storedColumnDataTypes[colId]) {
                                        case INT: {
                                            values[colId] = dataTable.getInt(rowId, colId);
                                            continue block23;
                                        }
                                        case LONG: {
                                            values[colId] = dataTable.getLong(rowId, colId);
                                            continue block23;
                                        }
                                        case FLOAT: {
                                            values[colId] = Float.valueOf(dataTable.getFloat(rowId, colId));
                                            continue block23;
                                        }
                                        case DOUBLE: {
                                            values[colId] = dataTable.getDouble(rowId, colId);
                                            continue block23;
                                        }
                                        case BIG_DECIMAL: {
                                            values[colId] = dataTable.getBigDecimal(rowId, colId);
                                            continue block23;
                                        }
                                        case STRING: {
                                            values[colId] = dataTable.getString(rowId, colId);
                                            continue block23;
                                        }
                                        case BYTES: {
                                            values[colId] = dataTable.getBytes(rowId, colId);
                                            continue block23;
                                        }
                                        case INT_ARRAY: {
                                            values[colId] = IntArrayList.wrap((int[])dataTable.getIntArray(rowId, colId));
                                            continue block23;
                                        }
                                        case LONG_ARRAY: {
                                            values[colId] = LongArrayList.wrap((long[])dataTable.getLongArray(rowId, colId));
                                            continue block23;
                                        }
                                        case FLOAT_ARRAY: {
                                            values[colId] = FloatArrayList.wrap((float[])dataTable.getFloatArray(rowId, colId));
                                            continue block23;
                                        }
                                        case DOUBLE_ARRAY: {
                                            values[colId] = DoubleArrayList.wrap((double[])dataTable.getDoubleArray(rowId, colId));
                                            continue block23;
                                        }
                                        case STRING_ARRAY: {
                                            values[colId] = ObjectArrayList.wrap((Object[])dataTable.getStringArray(rowId, colId));
                                            continue block23;
                                        }
                                        case OBJECT: {
                                            CustomObject customObject = dataTable.getCustomObject(rowId, colId);
                                            if (customObject == null) continue block23;
                                            values[colId] = ObjectSerDeUtils.deserialize(customObject);
                                            continue block23;
                                        }
                                        default: {
                                            throw new IllegalStateException();
                                        }
                                    }
                                }
                                if (nullHandlingEnabled) {
                                    for (colId = 0; colId < GroupByDataTableReducer.this._numColumns; ++colId) {
                                        if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(rowId)) continue;
                                        values[colId] = null;
                                    }
                                }
                                indexedTable.upsert(new Record(values));
                            }
                        }
                    }
                    catch (Throwable t) {
                        exception.compareAndSet(null, t);
                    }
                    finally {
                        countDownLatch.countDown();
                        Tracing.ThreadAccountantOps.clear();
                    }
                }
            });
        }
        try {
            long timeOutMs = reducerContext.getReduceTimeOutMs() - (System.currentTimeMillis() - start);
            if (!countDownLatch.await(timeOutMs, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Timed out in broker reduce phase");
            }
            Throwable t = (Throwable)exception.get();
            if (t != null) {
                Utils.rethrowException((Throwable)t);
            }
        }
        catch (InterruptedException e) {
            Exception killedErrorMsg = Tracing.getThreadAccountant().getErrorStatus();
            throw new EarlyTerminationException("Interrupted in broker reduce phase" + (String)(killedErrorMsg == null ? "" : " " + killedErrorMsg), (Throwable)e);
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        indexedTable.finish(true, true);
        return indexedTable;
    }

    private int getNumReduceThreadsToUse(int numDataTables, int maxReduceThreadsPerQuery) {
        if (numDataTables < 2) {
            return 1;
        }
        return Math.min(numDataTables, maxReduceThreadsPerQuery);
    }

    private void processSingleFinalResult(DataSchema dataSchema, DataTable dataTable, BrokerResponseNative brokerResponseNative) {
        ArrayList<Object[]> rows;
        PostAggregationHandler postAggregationHandler = new PostAggregationHandler(this._queryContext, dataSchema);
        DataSchema resultDataSchema = postAggregationHandler.getResultDataSchema();
        int numRows = dataTable.getNumberOfRows();
        int limit = this._queryContext.getLimit();
        if (numRows == 0 || limit == 0) {
            brokerResponseNative.setResultTable(new ResultTable(resultDataSchema, Collections.emptyList()));
            return;
        }
        FilterContext havingFilter = this._queryContext.getHavingFilter();
        if (havingFilter != null) {
            rows = new ArrayList<Object[]>();
            HavingFilterHandler havingFilterHandler = new HavingFilterHandler(havingFilter, postAggregationHandler, this._queryContext.isNullHandlingEnabled());
            for (int i = 0; i < numRows; ++i) {
                Object[] row = this.getConvertedRowWithFinalResult(dataTable, i);
                if (!havingFilterHandler.isMatch(row)) continue;
                rows.add(row);
                if (rows.size() != limit) {
                    continue;
                }
                break;
            }
        } else {
            numRows = Math.min(numRows, limit);
            rows = new ArrayList(numRows);
            for (int i = 0; i < numRows; ++i) {
                rows.add(this.getConvertedRowWithFinalResult(dataTable, i));
            }
        }
        List<Object[]> resultRows = this.calculateFinalResultRows(postAggregationHandler, rows);
        RewriterResult rewriterResult = ResultRewriteUtils.rewriteResult(resultDataSchema, resultRows);
        brokerResponseNative.setResultTable(new ResultTable(rewriterResult.getDataSchema(), rewriterResult.getRows()));
    }

    private List<Object[]> calculateFinalResultRows(PostAggregationHandler postAggregationHandler, List<Object[]> rows) {
        ArrayList<Object[]> resultRows = new ArrayList<Object[]>(rows.size());
        DataSchema.ColumnDataType[] resultColumnDataTypes = postAggregationHandler.getResultDataSchema().getColumnDataTypes();
        int numResultColumns = resultColumnDataTypes.length;
        for (Object[] row : rows) {
            Object[] resultRow = postAggregationHandler.getResult(row);
            for (int i = 0; i < numResultColumns; ++i) {
                Object value = resultRow[i];
                if (value == null) continue;
                resultRow[i] = resultColumnDataTypes[i].format(value);
            }
            resultRows.add(resultRow);
        }
        return resultRows;
    }

    private Object[] getConvertedRowWithFinalResult(DataTable dataTable, int rowId) {
        Object[] row = new Object[this._numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = dataTable.getDataSchema().getColumnDataTypes();
        for (int i = 0; i < this._numColumns; ++i) {
            row[i] = i < this._numGroupByExpressions ? this.getConvertedKey(dataTable, columnDataTypes[i], rowId, i) : AggregationFunctionUtils.getConvertedFinalResult(dataTable, columnDataTypes[i], rowId, i);
        }
        return row;
    }

    private Object getConvertedKey(DataTable dataTable, DataSchema.ColumnDataType columnDataType, int rowId, int colId) {
        switch (columnDataType) {
            case INT: {
                return dataTable.getInt(rowId, colId);
            }
            case LONG: {
                return dataTable.getLong(rowId, colId);
            }
            case FLOAT: {
                return Float.valueOf(dataTable.getFloat(rowId, colId));
            }
            case DOUBLE: {
                return dataTable.getDouble(rowId, colId);
            }
            case BIG_DECIMAL: {
                return dataTable.getBigDecimal(rowId, colId);
            }
            case BOOLEAN: {
                return dataTable.getInt(rowId, colId) == 1;
            }
            case TIMESTAMP: {
                return new Timestamp(dataTable.getLong(rowId, colId));
            }
            case STRING: 
            case JSON: {
                return dataTable.getString(rowId, colId);
            }
            case BYTES: {
                return dataTable.getBytes(rowId, colId).getBytes();
            }
        }
        throw new IllegalStateException("Illegal column data type in group key: " + columnDataType);
    }
}

