/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.QueryContext;

public class ReducerDataSchemaUtils {
    private ReducerDataSchemaUtils() {
    }

    public static DataSchema canonicalizeDataSchemaForAggregation(QueryContext queryContext, DataSchema dataSchema) {
        List<Pair<AggregationFunction, FilterContext>> filteredAggregationFunctions = queryContext.getFilteredAggregationFunctions();
        assert (filteredAggregationFunctions != null);
        int numAggregations = filteredAggregationFunctions.size();
        Preconditions.checkState((dataSchema.size() == numAggregations ? 1 : 0) != 0, (String)"BUG: Expect same number of aggregations and columns in data schema, got %s aggregations, %s columns in data schema", (int)numAggregations, (int)dataSchema.size());
        String[] columnNames = new String[numAggregations];
        for (int i = 0; i < numAggregations; ++i) {
            Pair<AggregationFunction, FilterContext> pair = filteredAggregationFunctions.get(i);
            AggregationFunction aggregationFunction = (AggregationFunction)pair.getLeft();
            columnNames[i] = AggregationFunctionUtils.getResultColumnName(aggregationFunction, (FilterContext)pair.getRight());
        }
        return new DataSchema(columnNames, dataSchema.getColumnDataTypes());
    }

    public static DataSchema canonicalizeDataSchemaForGroupBy(QueryContext queryContext, DataSchema dataSchema) {
        int i;
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        List<Pair<AggregationFunction, FilterContext>> filteredAggregationFunctions = queryContext.getFilteredAggregationFunctions();
        assert (groupByExpressions != null && filteredAggregationFunctions != null);
        int numGroupByExpression = groupByExpressions.size();
        int numAggregations = filteredAggregationFunctions.size();
        int numColumns = numGroupByExpression + numAggregations;
        String[] columnNames = new String[numColumns];
        Preconditions.checkState((dataSchema.size() == numColumns ? 1 : 0) != 0, (String)"BUG: Expect same number of group-by expressions, aggregations and columns in data schema, got %s group-by expressions, %s aggregations, %s columns in data schema", (Object)numGroupByExpression, (Object)numAggregations, (Object)dataSchema.size());
        for (i = 0; i < numGroupByExpression; ++i) {
            columnNames[i] = groupByExpressions.get(i).toString();
        }
        for (i = 0; i < numAggregations; ++i) {
            Pair<AggregationFunction, FilterContext> pair = filteredAggregationFunctions.get(i);
            columnNames[numGroupByExpression + i] = AggregationFunctionUtils.getResultColumnName((AggregationFunction)pair.getLeft(), (FilterContext)pair.getRight());
        }
        return new DataSchema(columnNames, dataSchema.getColumnDataTypes());
    }

    public static DataSchema canonicalizeDataSchemaForDistinct(QueryContext queryContext, DataSchema dataSchema) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        int numSelectExpressions = selectExpressions.size();
        Preconditions.checkState((dataSchema.size() == numSelectExpressions ? 1 : 0) != 0, (String)"BUG: Expect same number of columns in SELECT clause and data schema, got %s in SELECT clause, %s in data schema", (int)numSelectExpressions, (int)dataSchema.size());
        String[] columnNames = new String[numSelectExpressions];
        for (int i = 0; i < numSelectExpressions; ++i) {
            columnNames[i] = selectExpressions.get(i).toString();
        }
        return new DataSchema(columnNames, dataSchema.getColumnDataTypes());
    }
}

