/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.datatable.DataTableFactory;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.query.reduce.BaseReduceService;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.ExecutionStatsAggregator;
import org.apache.pinot.core.query.reduce.ResultReducerFactory;
import org.apache.pinot.core.query.reduce.StreamingReducer;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextConverterUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StreamingReduceService
extends BaseReduceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingReduceService.class);

    public StreamingReduceService(PinotConfiguration config) {
        super(config);
    }

    public BrokerResponseNative reduceOnStreamResponse(BrokerRequest brokerRequest, Map<ServerRoutingInstance, Iterator<Server.ServerResponse>> serverResponseMap, long reduceTimeOutMs, BrokerMetrics brokerMetrics) throws IOException {
        if (serverResponseMap.isEmpty()) {
            return BrokerResponseNative.empty();
        }
        PinotQuery pinotQuery = brokerRequest.getPinotQuery();
        Map queryOptions = pinotQuery.getQueryOptions();
        boolean enableTrace = queryOptions != null && Boolean.parseBoolean((String)queryOptions.get("trace"));
        QueryContext queryContext = QueryContextConverterUtils.getQueryContext(pinotQuery);
        String tableName = queryContext.getTableName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        ExecutionStatsAggregator aggregator = new ExecutionStatsAggregator(enableTrace);
        Integer minGroupTrimSizeQueryOption = null;
        Integer groupTrimThresholdQueryOption = null;
        if (queryOptions != null) {
            minGroupTrimSizeQueryOption = QueryOptionsUtils.getMinBrokerGroupTrimSize((Map)queryOptions);
            groupTrimThresholdQueryOption = QueryOptionsUtils.getGroupTrimThreshold((Map)queryOptions);
        }
        int minGroupTrimSize = minGroupTrimSizeQueryOption != null ? minGroupTrimSizeQueryOption : this._minGroupTrimSize;
        int groupTrimThreshold = groupTrimThresholdQueryOption != null ? groupTrimThresholdQueryOption : this._groupByTrimThreshold;
        DataTableReducerContext dataTableReducerContext = new DataTableReducerContext(this._reduceExecutorService, this._maxReduceThreadsPerQuery, reduceTimeOutMs, groupTrimThreshold, minGroupTrimSize);
        StreamingReducer streamingReducer = ResultReducerFactory.getStreamingReducer(queryContext);
        streamingReducer.init(dataTableReducerContext);
        try {
            StreamingReduceService.processIterativeServerResponse(streamingReducer, this._reduceExecutorService, serverResponseMap, reduceTimeOutMs, aggregator);
        }
        catch (Exception e) {
            LOGGER.error("Unable to process streaming query response!", (Throwable)e);
            throw new IOException("Unable to process streaming query response!", e);
        }
        BrokerResponseNative brokerResponseNative = streamingReducer.seal();
        aggregator.setStats(rawTableName, brokerResponseNative, brokerMetrics);
        StreamingReduceService.updateAlias(queryContext, brokerResponseNative);
        return brokerResponseNative;
    }

    @VisibleForTesting
    static void processIterativeServerResponse(StreamingReducer reducer, ExecutorService executorService, Map<ServerRoutingInstance, Iterator<Server.ServerResponse>> serverResponseMap, long reduceTimeOutMs, ExecutionStatsAggregator aggregator) throws Exception {
        int cnt = 0;
        CompletableFuture[] futures = new CompletableFuture[serverResponseMap.size()];
        for (Map.Entry<ServerRoutingInstance, Iterator<Server.ServerResponse>> entry : serverResponseMap.entrySet()) {
            futures[cnt++] = CompletableFuture.runAsync(() -> {
                Iterator streamingResponses = (Iterator)entry.getValue();
                try {
                    while (streamingResponses.hasNext()) {
                        Server.ServerResponse streamingResponse = (Server.ServerResponse)streamingResponses.next();
                        DataTable dataTable = DataTableFactory.getDataTable((ByteBuffer)streamingResponse.getPayload().asReadOnlyByteBuffer());
                        if (dataTable.getDataSchema() != null) {
                            reducer.reduce((ServerRoutingInstance)entry.getKey(), dataTable);
                            continue;
                        }
                        aggregator.aggregate((ServerRoutingInstance)entry.getKey(), dataTable);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Unable to process streaming response. Failure occurred!", (Throwable)e);
                    throw new RuntimeException("Unable to process streaming response. Failure occurred!", e);
                }
            }, executorService);
        }
        CompletableFuture<Void> syncWaitPoint = CompletableFuture.allOf(futures);
        try {
            syncWaitPoint.get(reduceTimeOutMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            syncWaitPoint.cancel(true);
            throw ex;
        }
    }

    @Override
    public void shutDown() {
        this._reduceExecutorService.shutdownNow();
    }
}

