/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.TimerContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextConverterUtils;
import org.apache.pinot.core.query.utils.QueryIdUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ServerQueryRequest {
    private final long _requestId;
    private final String _brokerId;
    private final boolean _enableTrace;
    private final boolean _enableStreaming;
    private final List<String> _segmentsToQuery;
    private final List<String> _optionalSegments;
    private final QueryContext _queryContext;
    private final String _queryId;
    private final TimerContext _timerContext;

    public ServerQueryRequest(InstanceRequest instanceRequest, ServerMetrics serverMetrics, long queryArrivalTimeMs) {
        this(instanceRequest, serverMetrics, queryArrivalTimeMs, false);
    }

    public ServerQueryRequest(InstanceRequest instanceRequest, ServerMetrics serverMetrics, long queryArrivalTimeMs, boolean enableStreaming) {
        this._requestId = instanceRequest.getRequestId();
        this._brokerId = instanceRequest.getBrokerId() != null ? instanceRequest.getBrokerId() : "unknown";
        this._enableTrace = instanceRequest.isEnableTrace();
        this._enableStreaming = enableStreaming;
        this._segmentsToQuery = instanceRequest.getSearchSegments();
        this._optionalSegments = instanceRequest.getOptionalSegments();
        this._queryContext = ServerQueryRequest.getQueryContext(instanceRequest.getQuery().getPinotQuery());
        this._queryId = QueryIdUtils.getQueryId(this._brokerId, this._requestId, TableNameBuilder.getTableTypeFromTableName((String)this._queryContext.getTableName()));
        this._timerContext = new TimerContext(this._queryContext.getTableName(), serverMetrics, queryArrivalTimeMs);
    }

    public ServerQueryRequest(Server.ServerRequest serverRequest, ServerMetrics serverMetrics) throws Exception {
        BrokerRequest brokerRequest;
        long queryArrivalTimeMs = System.currentTimeMillis();
        Map metadata = serverRequest.getMetadataMap();
        this._requestId = Long.parseLong(metadata.getOrDefault("requestId", "0"));
        this._brokerId = metadata.getOrDefault("brokerId", "unknown");
        this._enableTrace = Boolean.parseBoolean((String)metadata.get("enableTrace"));
        this._enableStreaming = Boolean.parseBoolean((String)metadata.get("enableStreaming"));
        this._segmentsToQuery = serverRequest.getSegmentsList();
        this._optionalSegments = null;
        String payloadType = metadata.getOrDefault("payloadType", "sql");
        if (payloadType.equalsIgnoreCase("sql")) {
            brokerRequest = CalciteSqlCompiler.compileToBrokerRequest((String)serverRequest.getSql());
        } else if (payloadType.equalsIgnoreCase("brokerRequest")) {
            brokerRequest = new BrokerRequest();
            new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory()).deserialize((TBase)brokerRequest, serverRequest.getPayload().toByteArray());
        } else {
            throw new UnsupportedOperationException("Unsupported payloadType: " + payloadType);
        }
        this._queryContext = ServerQueryRequest.getQueryContext(brokerRequest.getPinotQuery());
        this._queryId = QueryIdUtils.getQueryId(this._brokerId, this._requestId, TableNameBuilder.getTableTypeFromTableName((String)this._queryContext.getTableName()));
        this._timerContext = new TimerContext(this._queryContext.getTableName(), serverMetrics, queryArrivalTimeMs);
    }

    private static QueryContext getQueryContext(PinotQuery pinotQuery) {
        QueryContext queryContext = QueryContextConverterUtils.getQueryContext(pinotQuery);
        if (queryContext.isNullHandlingEnabled()) {
            Preconditions.checkState((DataTableBuilderFactory.getDataTableVersion() >= 4 ? 1 : 0) != 0, (Object)"Null handling cannot be enabled for data table version smaller than 4");
        }
        return queryContext;
    }

    public long getRequestId() {
        return this._requestId;
    }

    public String getBrokerId() {
        return this._brokerId;
    }

    public boolean isEnableTrace() {
        return this._enableTrace;
    }

    public boolean isEnableStreaming() {
        return this._enableStreaming;
    }

    public String getTableNameWithType() {
        return this._queryContext.getTableName();
    }

    public List<String> getSegmentsToQuery() {
        return this._segmentsToQuery;
    }

    public List<String> getOptionalSegments() {
        return this._optionalSegments;
    }

    public QueryContext getQueryContext() {
        return this._queryContext;
    }

    public String getQueryId() {
        return this._queryId;
    }

    public TimerContext getTimerContext() {
        return this._timerContext;
    }
}

