/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context.utils;

import java.util.List;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.request.context.QueryContext;

public class QueryContextUtils {
    private QueryContextUtils() {
    }

    public static boolean isSelectionQuery(QueryContext query) {
        return !query.isDistinct() && query.getAggregationFunctions() == null;
    }

    public static boolean isSelectionOnlyQuery(QueryContext query) {
        return QueryContextUtils.isSelectionQuery(query) && query.getOrderByExpressions() == null;
    }

    public static boolean isAggregationQuery(QueryContext query) {
        return query.getAggregationFunctions() != null;
    }

    public static boolean isDistinctQuery(QueryContext query) {
        return query.isDistinct();
    }

    public static void collectPostAggregations(QueryContext queryContext, Set<String> postAggregations) {
        for (ExpressionContext selectExpression : queryContext.getSelectExpressions()) {
            QueryContextUtils.collectPostAggregations(selectExpression, postAggregations);
        }
        if (queryContext.getHavingFilter() != null) {
            QueryContextUtils.collectPostAggregations(queryContext.getHavingFilter(), postAggregations);
        }
        if (queryContext.getOrderByExpressions() != null) {
            for (OrderByExpressionContext orderByExpression : queryContext.getOrderByExpressions()) {
                QueryContextUtils.collectPostAggregations(orderByExpression.getExpression(), postAggregations);
            }
        }
        if (queryContext.getGroupByExpressions() != null) {
            for (ExpressionContext groupByExpression : queryContext.getGroupByExpressions()) {
                QueryContextUtils.collectPostAggregations(groupByExpression, postAggregations);
            }
        }
    }

    public static void collectPostAggregations(ExpressionContext expression, Set<String> postAggregations) {
        FunctionContext function = expression.getFunction();
        if (function != null) {
            if (function.getType() == FunctionContext.Type.TRANSFORM) {
                if (QueryContextUtils.isPostAggregation(function)) {
                    postAggregations.add(function.toString());
                }
            } else {
                for (ExpressionContext argument : function.getArguments()) {
                    QueryContextUtils.collectPostAggregations(argument, postAggregations);
                }
            }
        }
    }

    public static boolean isPostAggregation(FunctionContext function) {
        if (function != null) {
            if (function.getType() == FunctionContext.Type.AGGREGATION) {
                return true;
            }
            for (ExpressionContext argument : function.getArguments()) {
                if (!QueryContextUtils.isPostAggregation(argument.getFunction())) continue;
                return true;
            }
        }
        return false;
    }

    public static void collectPostAggregations(FilterContext filter, Set<String> postAggregations) {
        List children = filter.getChildren();
        if (children != null) {
            for (FilterContext child : children) {
                QueryContextUtils.collectPostAggregations(child, postAggregations);
            }
        } else {
            QueryContextUtils.collectPostAggregations(filter.getPredicate().getLhs(), postAggregations);
        }
    }
}

