/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.LongAccumulator;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.operator.blocks.results.ExceptionResultsBlock;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.logger.ServerQueryLogger;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.request.context.TimerContext;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.apache.pinot.spi.exception.QueryCancelledException;
import org.apache.pinot.spi.trace.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryScheduler.class);
    protected final ServerMetrics _serverMetrics;
    protected final QueryExecutor _queryExecutor;
    protected final ResourceManager _resourceManager;
    protected final LongAccumulator _latestQueryTime;
    protected final ServerQueryLogger _queryLogger = ServerQueryLogger.getInstance();
    protected volatile boolean _isRunning = false;

    public QueryScheduler(PinotConfiguration config, QueryExecutor queryExecutor, ResourceManager resourceManager, ServerMetrics serverMetrics, LongAccumulator latestQueryTime) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)queryExecutor);
        Preconditions.checkNotNull((Object)resourceManager);
        Preconditions.checkNotNull((Object)serverMetrics);
        Preconditions.checkNotNull((Object)latestQueryTime);
        this._serverMetrics = serverMetrics;
        this._resourceManager = resourceManager;
        this._queryExecutor = queryExecutor;
        this._latestQueryTime = latestQueryTime;
    }

    public abstract ListenableFuture<byte[]> submit(ServerQueryRequest var1);

    public abstract String name();

    public void start() {
        this._isRunning = true;
    }

    public void stop() {
        this._isRunning = false;
    }

    protected ListenableFutureTask<byte[]> createQueryFutureTask(ServerQueryRequest queryRequest, ExecutorService executorService) {
        return ListenableFutureTask.create(() -> this.processQueryAndSerialize(queryRequest, executorService));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected byte[] processQueryAndSerialize(ServerQueryRequest queryRequest, ExecutorService executorService) {
        InstanceResponseBlock instanceResponse;
        Tracing.ThreadAccountantOps.setupRunner((String)queryRequest.getQueryId());
        this._latestQueryTime.accumulate(System.currentTimeMillis());
        try {
            instanceResponse = this._queryExecutor.execute(queryRequest, executorService);
        }
        catch (Exception e) {
            LOGGER.error("Encountered exception while processing requestId {} from broker {}", new Object[]{queryRequest.getRequestId(), queryRequest.getBrokerId(), e});
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.UNCAUGHT_EXCEPTIONS, 1L);
            instanceResponse = new InstanceResponseBlock();
            instanceResponse.addException(QueryException.getException((ProcessingException)QueryException.INTERNAL_ERROR, (Throwable)e));
        }
        try {
            Map<String, String> queryOptions;
            Long maxResponseSizeBytes;
            long requestId = queryRequest.getRequestId();
            Map<String, String> responseMetadata = instanceResponse.getResponseMetadata();
            responseMetadata.put(DataTable.MetadataKey.REQUEST_ID.getName(), Long.toString(requestId));
            byte[] responseBytes = this.serializeResponse(queryRequest, instanceResponse);
            if (this._queryLogger != null) {
                this._queryLogger.logQuery(queryRequest, instanceResponse, this.name());
            }
            if ((maxResponseSizeBytes = QueryOptionsUtils.getMaxServerResponseSizeBytes(queryOptions = queryRequest.getQueryContext().getQueryOptions())) != null && responseBytes != null && (long)responseBytes.length > maxResponseSizeBytes) {
                String errMsg = String.format("Serialized query response size %d exceeds threshold %d for requestId %d from broker %s", responseBytes.length, maxResponseSizeBytes, queryRequest.getRequestId(), queryRequest.getBrokerId());
                LOGGER.error(errMsg);
                this._serverMetrics.addMeteredTableValue(queryRequest.getTableNameWithType(), (AbstractMetrics.Meter)ServerMeter.LARGE_QUERY_RESPONSE_SIZE_EXCEPTIONS, 1L);
                instanceResponse = new InstanceResponseBlock();
                instanceResponse.addException(QueryException.getException((ProcessingException)QueryException.QUERY_CANCELLATION_ERROR, (String)errMsg));
                instanceResponse.addMetadata(DataTable.MetadataKey.REQUEST_ID.getName(), Long.toString(requestId));
                responseBytes = this.serializeResponse(queryRequest, instanceResponse);
            }
            byte[] byArray = responseBytes;
            return byArray;
        }
        finally {
            Tracing.ThreadAccountantOps.clear();
        }
    }

    private boolean forceLog(long schedulerWaitMs, long numDocsScanned, long numSegmentsPrunedInvalid) {
        if (schedulerWaitMs > 100L) {
            return true;
        }
        if (numSegmentsPrunedInvalid > 0L) {
            return true;
        }
        return numDocsScanned > 1000000L;
    }

    @Nullable
    private byte[] serializeResponse(ServerQueryRequest queryRequest, InstanceResponseBlock instanceResponse) {
        TimerContext timerContext = queryRequest.getTimerContext();
        TimerContext.Timer responseSerializationTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.RESPONSE_SERIALIZATION);
        byte[] responseByte = null;
        try {
            responseByte = instanceResponse.toDataTable().toBytes();
        }
        catch (EarlyTerminationException e) {
            Exception killedErrorMsg = Tracing.getThreadAccountant().getErrorStatus();
            String errMsg = "Cancelled while building data table" + (String)(killedErrorMsg == null ? "" : " " + killedErrorMsg);
            LOGGER.error(errMsg);
            instanceResponse = new InstanceResponseBlock(new ExceptionResultsBlock(new QueryCancelledException(errMsg, (Throwable)e)));
            instanceResponse.addMetadata(DataTable.MetadataKey.REQUEST_ID.getName(), Long.toString(queryRequest.getRequestId()));
            return this.serializeResponse(queryRequest, instanceResponse);
        }
        catch (Exception e) {
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.RESPONSE_SERIALIZATION_EXCEPTIONS, 1L);
            LOGGER.error("Caught exception while serializing response for requestId: {}, brokerId: {}", new Object[]{queryRequest.getRequestId(), queryRequest.getBrokerId(), e});
        }
        responseSerializationTimer.stopAndRecord();
        timerContext.startNewPhaseTimer(ServerQueryPhase.TOTAL_QUERY_TIME, timerContext.getQueryArrivalTimeMs()).stopAndRecord();
        return responseByte;
    }

    protected ListenableFuture<byte[]> immediateErrorResponse(ServerQueryRequest queryRequest, ProcessingException error) {
        InstanceResponseBlock instanceResponse = new InstanceResponseBlock();
        instanceResponse.addMetadata(DataTable.MetadataKey.REQUEST_ID.getName(), Long.toString(queryRequest.getRequestId()));
        instanceResponse.addException(error);
        return Futures.immediateFuture((Object)this.serializeResponse(queryRequest, instanceResponse));
    }
}

