/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import javax.annotation.Nullable;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.SchedulerGroup;

public class SchedulerQueryContext {
    private final ServerQueryRequest _queryRequest;
    private final SettableFuture<byte[]> _resultFuture;
    private SchedulerGroup _schedulerGroup;

    public SchedulerQueryContext(ServerQueryRequest queryRequest) {
        Preconditions.checkNotNull((Object)queryRequest);
        this._queryRequest = queryRequest;
        this._resultFuture = SettableFuture.create();
    }

    public ServerQueryRequest getQueryRequest() {
        return this._queryRequest;
    }

    public SettableFuture<byte[]> getResultFuture() {
        return this._resultFuture;
    }

    public void setResultFuture(ListenableFuture<byte[]> f) {
        this._resultFuture.setFuture(f);
    }

    public void setSchedulerGroupContext(SchedulerGroup schedulerGroup) {
        this._schedulerGroup = schedulerGroup;
    }

    @Nullable
    public SchedulerGroup getSchedulerGroup() {
        return this._schedulerGroup;
    }

    public long getArrivalTimeMs() {
        return this._queryRequest.getTimerContext().getQueryArrivalTimeMs();
    }
}

