/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler.resources;

import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLimitPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceLimitPolicy.class);
    static final int MAX_THREAD_LIMIT = Math.max(1, Runtime.getRuntime().availableProcessors());
    public static final String THREADS_PER_QUERY_PCT = "threads_per_query_pct";
    public static final int DEFAULT_THREADS_PER_QUERY_PCT = 20;
    public static final String TABLE_THREADS_SOFT_LIMIT = "table_threads_soft_limit_pct";
    public static final String TABLE_THREADS_HARD_LIMIT = "table_threads_hard_limit_pct";
    public static final int DEFAULT_TABLE_THREADS_SOFT_LIMIT = 30;
    public static final int DEFAULT_TABLE_THREADS_HARD_LIMIT = 45;
    private final int _maxThreadsPerQuery;
    private final int _tableThreadsSoftLimit;
    private final int _tableThreadsHardLimit;

    public ResourceLimitPolicy(PinotConfiguration config, int numWorkerThreads) {
        int softLimit = this.checkGetOrDefaultPct(config, TABLE_THREADS_SOFT_LIMIT, 30);
        this._tableThreadsSoftLimit = Math.min(numWorkerThreads, Math.max(1, numWorkerThreads * softLimit / 100));
        int hardLimit = this.checkGetOrDefaultPct(config, TABLE_THREADS_HARD_LIMIT, 45);
        this._tableThreadsHardLimit = Math.min(numWorkerThreads, Math.max(this._tableThreadsSoftLimit, numWorkerThreads * hardLimit / 100));
        int tpqPct = this.checkGetOrDefaultPct(config, THREADS_PER_QUERY_PCT, 20);
        this._maxThreadsPerQuery = Math.min(this._tableThreadsHardLimit, Math.min(MAX_THREAD_LIMIT, Math.max(1, numWorkerThreads * tpqPct / 100)));
        LOGGER.info("MaxThreadsPerQuery: {}, tableThreadsSoftLimit: {}, tableThreadsHardLimit: {}", new Object[]{this._maxThreadsPerQuery, this._tableThreadsSoftLimit, this._tableThreadsHardLimit});
    }

    private int checkGetOrDefaultPct(PinotConfiguration schedulerConfig, String key, int defaultValue) {
        int pct = schedulerConfig.getProperty(key, defaultValue);
        if (pct <= 0 || pct > 100) {
            LOGGER.error("Incorrect value for {}, value: {}; using default: {}", new Object[]{key, pct, defaultValue});
            pct = defaultValue;
        }
        return pct;
    }

    public int getMaxThreadsPerQuery() {
        return this._maxThreadsPerQuery;
    }

    public int getTableThreadsSoftLimit() {
        return this._tableThreadsSoftLimit;
    }

    public int getTableThreadsHardLimit() {
        return this._tableThreadsHardLimit;
    }
}

