/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.utils;

import java.util.Comparator;
import java.util.List;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.operator.ColumnContext;
import org.apache.pinot.spi.exception.BadQueryRequestException;

public class OrderByComparatorFactory {
    private OrderByComparatorFactory() {
    }

    public static Comparator<Object[]> getComparator(List<OrderByExpressionContext> orderByExpressions, ColumnContext[] orderByColumnContexts, boolean nullHandlingEnabled) {
        return OrderByComparatorFactory.getComparator(orderByExpressions, orderByColumnContexts, nullHandlingEnabled, 0, orderByExpressions.size());
    }

    public static Comparator<Object[]> getComparator(List<OrderByExpressionContext> orderByExpressions, ColumnContext[] orderByColumnContexts, boolean nullHandlingEnabled, int from, int to) {
        assert (0 <= from && from < to && to <= orderByExpressions.size());
        for (int i = from; i < to; ++i) {
            if (orderByColumnContexts[i].isSingleValue()) continue;
            throw new BadQueryRequestException(String.format("MV expression: %s should not be included in the ORDER-BY clause", orderByExpressions.get(i)));
        }
        return OrderByComparatorFactory.getComparator(orderByExpressions, nullHandlingEnabled, from, to);
    }

    public static Comparator<Object[]> getComparator(List<OrderByExpressionContext> orderByExpressions, boolean nullHandlingEnabled) {
        return OrderByComparatorFactory.getComparator(orderByExpressions, nullHandlingEnabled, 0, orderByExpressions.size());
    }

    public static Comparator<Object[]> getComparator(List<OrderByExpressionContext> orderByExpressions, boolean nullHandlingEnabled, int from, int to) {
        assert (0 <= from && from < to && to <= orderByExpressions.size());
        int[] multipliers = new int[to];
        int[] nullsMultipliers = new int[to];
        for (int i = from; i < to; ++i) {
            multipliers[i] = orderByExpressions.get(i).isAsc() ? 1 : -1;
            nullsMultipliers[i] = orderByExpressions.get(i).isNullsLast() ? 1 : -1;
        }
        if (nullHandlingEnabled) {
            return (o1, o2) -> {
                for (int i = from; i < to; ++i) {
                    Comparable v1 = (Comparable)o1[i];
                    Comparable v2 = (Comparable)o2[i];
                    if (v1 == null && v2 == null) continue;
                    if (v1 == null) {
                        return nullsMultipliers[i];
                    }
                    if (v2 == null) {
                        return -nullsMultipliers[i];
                    }
                    int result = v1.compareTo(v2);
                    if (result == 0) continue;
                    return result * multipliers[i];
                }
                return 0;
            };
        }
        return (o1, o2) -> {
            for (int i = from; i < to; ++i) {
                Comparable v1 = (Comparable)o1[i];
                Comparable v2 = (Comparable)o2[i];
                int result = v1.compareTo(v2);
                if (result == 0) continue;
                return result * multipliers[i];
            }
            return 0;
        };
    }
}

