/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.utils;

import org.apache.pinot.spi.config.table.TableType;

public class QueryIdUtils {
    public static final String OFFLINE_SUFFIX = "_O";
    public static final String REALTIME_SUFFIX = "_R";

    private QueryIdUtils() {
    }

    public static String getQueryId(String brokerId, long requestId, TableType tableType) {
        return brokerId + "_" + requestId + (tableType == TableType.OFFLINE ? OFFLINE_SUFFIX : REALTIME_SUFFIX);
    }

    public static boolean hasTypeSuffix(String queryId) {
        return queryId.endsWith(OFFLINE_SUFFIX) || queryId.endsWith(REALTIME_SUFFIX);
    }

    public static String withOfflineSuffix(String queryId) {
        return queryId + OFFLINE_SUFFIX;
    }

    public static String withRealtimeSuffix(String queryId) {
        return queryId + REALTIME_SUFFIX;
    }
}

