/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.utils.idset;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import org.apache.pinot.core.query.utils.idset.BloomFilterIdSet;
import org.apache.pinot.core.query.utils.idset.EmptyIdSet;
import org.apache.pinot.core.query.utils.idset.IdSet;
import org.apache.pinot.core.query.utils.idset.Roaring64NavigableMapIdSet;
import org.apache.pinot.core.query.utils.idset.RoaringBitmapIdSet;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.longlong.LongIterator;

public class IdSets {
    public static final int DEFAULT_SIZE_THRESHOLD_IN_BYTES = 0x800000;
    public static final int DEFAULT_EXPECTED_INSERTIONS = 5000000;
    public static final double DEFAULT_FPP = 0.03;

    private IdSets() {
    }

    public static IdSet create(FieldSpec.DataType dataType) {
        return IdSets.create(dataType, 0x800000, 5000000, 0.03);
    }

    public static IdSet create(FieldSpec.DataType dataType, int sizeThresholdInBytes, int expectedInsertions, double fpp) {
        if (sizeThresholdInBytes <= 0) {
            return new BloomFilterIdSet(dataType, expectedInsertions, fpp);
        }
        switch (dataType) {
            case INT: {
                return new RoaringBitmapIdSet();
            }
            case LONG: {
                return new Roaring64NavigableMapIdSet();
            }
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BYTES: {
                return new BloomFilterIdSet(dataType, expectedInsertions, fpp);
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType);
    }

    public static EmptyIdSet emptyIdSet() {
        return EmptyIdSet.INSTANCE;
    }

    public static IdSet merge(IdSet idSet1, IdSet idSet2) {
        return IdSets.merge(idSet1, idSet2, 0x800000, 5000000, 0.03);
    }

    public static IdSet merge(IdSet idSet1, IdSet idSet2, int sizeThresholdInBytes, int expectedInsertions, double fpp) {
        IdSet.Type nonBloomFilterIdSetType;
        IdSet nonBloomFilterIdSet;
        BloomFilterIdSet bloomFilterIdSet;
        IdSet.Type idSet1Type = idSet1.getType();
        if (idSet1Type == IdSet.Type.EMPTY) {
            return idSet2;
        }
        IdSet.Type idSet2Type = idSet2.getType();
        if (idSet2Type == IdSet.Type.EMPTY) {
            return idSet1;
        }
        if (idSet1Type == idSet2Type) {
            switch (idSet1Type) {
                case ROARING_BITMAP: {
                    RoaringBitmapIdSet roaringBitmapIdSet = (RoaringBitmapIdSet)idSet1;
                    roaringBitmapIdSet.getBitmap().or(((RoaringBitmapIdSet)idSet2).getBitmap());
                    return IdSets.convertToBloomFilterIdSetIfNeeded(roaringBitmapIdSet, sizeThresholdInBytes, expectedInsertions, fpp);
                }
                case ROARING_64_NAVIGABLE_MAP: {
                    Roaring64NavigableMapIdSet roaring64NavigableMapIdSet = (Roaring64NavigableMapIdSet)idSet1;
                    roaring64NavigableMapIdSet.getBitmap().or(((Roaring64NavigableMapIdSet)idSet2).getBitmap());
                    return IdSets.convertToBloomFilterIdSetIfNeeded(roaring64NavigableMapIdSet, sizeThresholdInBytes, expectedInsertions, fpp);
                }
                case BLOOM_FILTER: {
                    BloomFilterIdSet bloomFilterIdSet2 = (BloomFilterIdSet)idSet1;
                    bloomFilterIdSet2.getBloomFilter().putAll(((BloomFilterIdSet)idSet2).getBloomFilter());
                    return bloomFilterIdSet2;
                }
            }
            throw new IllegalStateException();
        }
        if (idSet1Type == IdSet.Type.BLOOM_FILTER) {
            bloomFilterIdSet = (BloomFilterIdSet)idSet1;
            nonBloomFilterIdSet = idSet2;
            nonBloomFilterIdSetType = idSet2Type;
        } else {
            assert (idSet2Type == IdSet.Type.BLOOM_FILTER);
            bloomFilterIdSet = (BloomFilterIdSet)idSet2;
            nonBloomFilterIdSet = idSet1;
            nonBloomFilterIdSetType = idSet1Type;
        }
        if (nonBloomFilterIdSetType == IdSet.Type.ROARING_BITMAP) {
            PeekableIntIterator intIterator = ((RoaringBitmapIdSet)nonBloomFilterIdSet).getBitmap().getIntIterator();
            while (intIterator.hasNext()) {
                bloomFilterIdSet.add(intIterator.next());
            }
        } else {
            assert (nonBloomFilterIdSetType == IdSet.Type.ROARING_64_NAVIGABLE_MAP);
            LongIterator longIterator = ((Roaring64NavigableMapIdSet)nonBloomFilterIdSet).getBitmap().getLongIterator();
            while (longIterator.hasNext()) {
                bloomFilterIdSet.add(longIterator.next());
            }
        }
        return bloomFilterIdSet;
    }

    private static IdSet convertToBloomFilterIdSetIfNeeded(RoaringBitmapIdSet roaringBitmapIdSet, int sizeThreshold, int expectedInsertions, double fpp) {
        if (roaringBitmapIdSet.getSerializedSizeInBytes() <= sizeThreshold) {
            return roaringBitmapIdSet;
        }
        BloomFilterIdSet bloomFilterIdSet = new BloomFilterIdSet(FieldSpec.DataType.INT, expectedInsertions, fpp);
        PeekableIntIterator intIterator = roaringBitmapIdSet.getBitmap().getIntIterator();
        while (intIterator.hasNext()) {
            bloomFilterIdSet.add(intIterator.next());
        }
        return bloomFilterIdSet;
    }

    private static IdSet convertToBloomFilterIdSetIfNeeded(Roaring64NavigableMapIdSet roaring64NavigableMapIdSet, int sizeThreshold, int expectedInsertions, double fpp) {
        if (roaring64NavigableMapIdSet.getSerializedSizeInBytes() <= sizeThreshold) {
            return roaring64NavigableMapIdSet;
        }
        BloomFilterIdSet bloomFilterIdSet = new BloomFilterIdSet(FieldSpec.DataType.LONG, expectedInsertions, fpp);
        LongIterator longIterator = roaring64NavigableMapIdSet.getBitmap().getLongIterator();
        while (longIterator.hasNext()) {
            bloomFilterIdSet.add(longIterator.next());
        }
        return bloomFilterIdSet;
    }

    public static IdSet fromBytes(byte[] bytes) throws IOException {
        return IdSets.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    public static IdSet fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
        byte typeId = byteBuffer.get();
        switch (typeId) {
            case 0: {
                return EmptyIdSet.INSTANCE;
            }
            case 1: {
                return RoaringBitmapIdSet.fromByteBuffer(byteBuffer);
            }
            case 2: {
                return Roaring64NavigableMapIdSet.fromByteBuffer(byteBuffer);
            }
            case 3: {
                return BloomFilterIdSet.fromByteBuffer(byteBuffer);
            }
        }
        throw new IllegalStateException();
    }

    public static IdSet fromBase64String(String base64String) throws IOException {
        return IdSets.fromBytes(Base64.getDecoder().decode(base64String));
    }
}

