/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.utils.rewriter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.utils.ParentAggregationFunctionResultObject;
import org.apache.pinot.core.query.utils.rewriter.ResultRewriter;
import org.apache.pinot.core.query.utils.rewriter.RewriterResult;

public class ParentAggregationResultRewriter
implements ResultRewriter {
    private static Map<String, ChildFunctionMapping> createChildFunctionMapping(DataSchema schema, Object[] row) {
        HashMap<String, ChildFunctionMapping> childFunctionMapping = new HashMap<String, ChildFunctionMapping>();
        for (int i = 0; i < schema.size(); ++i) {
            String columnName = schema.getColumnName(i);
            if (!columnName.startsWith("pinotparentagg")) continue;
            ParentAggregationFunctionResultObject parent = (ParentAggregationFunctionResultObject)row[i];
            DataSchema nestedSchema = parent.getSchema();
            for (int j = 0; j < nestedSchema.size(); ++j) {
                String childColumnKey = nestedSchema.getColumnName(j);
                String originalChildFunctionKey = columnName.substring("pinotparentagg".length()) + "_" + childColumnKey;
                childFunctionMapping.put(originalChildFunctionKey, new ChildFunctionMapping(parent, j, i));
            }
        }
        return childFunctionMapping;
    }

    @Override
    public RewriterResult rewrite(DataSchema dataSchema, List<Object[]> rows) {
        int numParentAggregationFunctions = 0;
        for (int i = 0; i < dataSchema.size(); ++i) {
            if (!dataSchema.getColumnName(i).startsWith("pinotparentagg")) continue;
            ++numParentAggregationFunctions;
        }
        if (numParentAggregationFunctions == 0) {
            return new RewriterResult(dataSchema, rows);
        }
        Map<String, ChildFunctionMapping> childFunctionMapping = null;
        if (!rows.isEmpty()) {
            childFunctionMapping = ParentAggregationResultRewriter.createChildFunctionMapping(dataSchema, rows.get(0));
        }
        String[] newColumnNames = new String[dataSchema.size() - numParentAggregationFunctions];
        DataSchema.ColumnDataType[] newColumnDataTypes = new DataSchema.ColumnDataType[dataSchema.size() - numParentAggregationFunctions];
        HashMap<Integer, Integer> aggregationFunctionIndexMapping = new HashMap<Integer, Integer>();
        HashSet<Integer> childAggregationFunctionIndices = new HashSet<Integer>();
        HashMap<Integer, Integer> childAggregationFunctionNestedIndexMapping = new HashMap<Integer, Integer>();
        HashSet<Integer> parentAggregationFunctionIndices = new HashSet<Integer>();
        int j = 0;
        for (int i = 0; i < dataSchema.size(); ++i) {
            String columnName = dataSchema.getColumnName(i);
            if (columnName.startsWith("pinotparentagg")) {
                parentAggregationFunctionIndices.add(i);
                continue;
            }
            if (columnName.startsWith("pinotchildagg")) {
                String childAggregationFunctionNameWithKey = columnName.substring("pinotchildagg".length());
                String[] s = childAggregationFunctionNameWithKey.split("@");
                newColumnNames[j] = s[0];
                if (childFunctionMapping == null) {
                    newColumnDataTypes[j] = DataSchema.ColumnDataType.STRING;
                    ++j;
                    continue;
                }
                ChildFunctionMapping childFunction = childFunctionMapping.get(s[1]);
                newColumnDataTypes[j] = childFunction.getParent().getSchema().getColumnDataType(childFunction.getNestedOffset());
                childAggregationFunctionNestedIndexMapping.put(j, childFunction.getNestedOffset());
                childAggregationFunctionIndices.add(j);
                aggregationFunctionIndexMapping.put(j, childFunction.getOffset());
            } else {
                newColumnNames[j] = columnName;
                newColumnDataTypes[j] = dataSchema.getColumnDataType(i);
                aggregationFunctionIndexMapping.put(j, i);
            }
            ++j;
        }
        DataSchema newDataSchema = new DataSchema(newColumnNames, newColumnDataTypes);
        ArrayList<Object[]> newRows = new ArrayList<Object[]>();
        for (Object[] row : rows) {
            int maxRows = parentAggregationFunctionIndices.stream().map(k -> {
                ParentAggregationFunctionResultObject parentAggregationFunctionResultObject = (ParentAggregationFunctionResultObject)row[k];
                return parentAggregationFunctionResultObject.getNumberOfRows();
            }).max(Integer::compareTo).orElse(0);
            maxRows = maxRows == 0 ? 1 : maxRows;
            ArrayList<Object[]> newRowsBuffer = new ArrayList<Object[]>();
            for (int rowIter = 0; rowIter < maxRows; ++rowIter) {
                Object[] newRow = new Object[newDataSchema.size()];
                for (int fieldIter = 0; fieldIter < newDataSchema.size(); ++fieldIter) {
                    if (childAggregationFunctionIndices.contains(fieldIter)) {
                        int offset = (Integer)aggregationFunctionIndexMapping.get(fieldIter);
                        int nestedOffset = (Integer)childAggregationFunctionNestedIndexMapping.get(fieldIter);
                        ParentAggregationFunctionResultObject parentAggregationFunctionResultObject = (ParentAggregationFunctionResultObject)row[offset];
                        if (rowIter < parentAggregationFunctionResultObject.getNumberOfRows()) {
                            newRow[fieldIter] = parentAggregationFunctionResultObject.getField(rowIter, nestedOffset);
                            continue;
                        }
                        newRow[fieldIter] = null;
                        continue;
                    }
                    newRow[fieldIter] = row[(Integer)aggregationFunctionIndexMapping.get(fieldIter)];
                }
                newRowsBuffer.add(newRow);
            }
            newRows.addAll(newRowsBuffer);
        }
        return new RewriterResult(newDataSchema, newRows);
    }

    private static class ChildFunctionMapping {
        private final ParentAggregationFunctionResultObject _parent;
        private final int _nestedOffset;
        private final int _offset;

        public ChildFunctionMapping(ParentAggregationFunctionResultObject parent, int nestedOffset, int offset) {
            this._parent = parent;
            this._nestedOffset = nestedOffset;
            this._offset = offset;
        }

        public int getOffset() {
            return this._offset;
        }

        public ParentAggregationFunctionResultObject getParent() {
            return this._parent;
        }

        public int getNestedOffset() {
            return this._nestedOffset;
        }
    }
}

