/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.utils.rewriter;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.core.query.utils.rewriter.ResultRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultRewriterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultRewriterFactory.class);
    static final List<String> DEFAULT_RESULT_REWRITERS_CLASS_NAMES = ImmutableList.of();
    static AtomicReference<List<ResultRewriter>> _resultRewriters = new AtomicReference<List<ResultRewriter>>(ResultRewriterFactory.getResultRewriter(DEFAULT_RESULT_REWRITERS_CLASS_NAMES));

    private ResultRewriterFactory() {
    }

    public static void init(String resultRewritersClassNamesStr) {
        List<String> resultRewritersClassNames = resultRewritersClassNamesStr != null ? Arrays.asList(resultRewritersClassNamesStr.split(",")) : DEFAULT_RESULT_REWRITERS_CLASS_NAMES;
        _resultRewriters.set(ResultRewriterFactory.getResultRewriter(resultRewritersClassNames));
    }

    public static List<ResultRewriter> getResultRewriter() {
        return _resultRewriters.get();
    }

    private static List<ResultRewriter> getResultRewriter(List<String> resultRewriterClasses) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String resultRewriterClassName : resultRewriterClasses) {
            try {
                builder.add((Object)ResultRewriterFactory.getResultRewriter(resultRewriterClassName));
            }
            catch (Exception e) {
                LOGGER.error("Failed to load resultRewriter: {}", (Object)resultRewriterClassName, (Object)e);
            }
        }
        return builder.build();
    }

    private static ResultRewriter getResultRewriter(String resultRewriterClassName) throws Exception {
        Class<?> resultRewriterClass = Class.forName(resultRewriterClassName);
        return (ResultRewriter)resultRewriterClass.getDeclaredConstructors()[0].newInstance(new Object[0]);
    }
}

