/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.framework;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SegmentConfig {
    public static final int DEFAULT_MAX_NUM_RECORDS_PER_SEGMENT = 5000000;
    public static final long DEFAULT_SEGMENT_MAPPER_FILE_SIZE_IN_BYTES = Long.MAX_VALUE;
    private final int _maxNumRecordsPerSegment;
    private final String _segmentNamePrefix;
    private final String _segmentNamePostfix;
    private final String _fixedSegmentName;
    private final long _segmentMapperFileSizeThresholdInBytes;

    @JsonCreator
    private SegmentConfig(@JsonProperty(value="maxNumRecordsPerSegment", required=true) int maxNumRecordsPerSegment, @JsonProperty(value="segmentNamePrefix") @Nullable String segmentNamePrefix, @JsonProperty(value="segmentNamePostfix") @Nullable String segmentNamePostfix, @JsonProperty(value="fixedSegmentName") @Nullable String fixedSegmentName, @JsonProperty(value="segmentMapperFileSizeThresholdInBytes", required=true) long segmentMapperFileSizeThresholdInBytes) {
        Preconditions.checkState((maxNumRecordsPerSegment > 0 ? 1 : 0) != 0, (Object)"Max num records per segment must be > 0");
        Preconditions.checkState((segmentMapperFileSizeThresholdInBytes > 0L ? 1 : 0) != 0, (Object)"Intermediate file size threshold must be > 0");
        this._maxNumRecordsPerSegment = maxNumRecordsPerSegment;
        this._segmentNamePrefix = segmentNamePrefix;
        this._segmentNamePostfix = segmentNamePostfix;
        this._fixedSegmentName = fixedSegmentName;
        this._segmentMapperFileSizeThresholdInBytes = segmentMapperFileSizeThresholdInBytes;
    }

    public int getMaxNumRecordsPerSegment() {
        return this._maxNumRecordsPerSegment;
    }

    @Nullable
    public String getSegmentNamePrefix() {
        return this._segmentNamePrefix;
    }

    @Nullable
    public String getSegmentNamePostfix() {
        return this._segmentNamePostfix;
    }

    @Nullable
    public String getFixedSegmentName() {
        return this._fixedSegmentName;
    }

    public long getIntermediateFileSizeThreshold() {
        return this._segmentMapperFileSizeThresholdInBytes;
    }

    public String toString() {
        return "SegmentConfig{_maxNumRecordsPerSegment=" + this._maxNumRecordsPerSegment + ", _segmentMapperFileSizeThresholdInBytes=" + this._segmentMapperFileSizeThresholdInBytes + ", _segmentNamePrefix='" + this._segmentNamePrefix + "', _segmentNamePostfix='" + this._segmentNamePostfix + "', _fixedSegmentName='" + this._fixedSegmentName + "'}";
    }

    public static class Builder {
        private int _maxNumRecordsPerSegment = 5000000;
        private long _segmentMapperFileSizeThresholdInBytes = Long.MAX_VALUE;
        private String _segmentNamePrefix;
        private String _segmentNamePostfix;
        private String _fixedSegmentName;

        public Builder setMaxNumRecordsPerSegment(int maxNumRecordsPerSegment) {
            this._maxNumRecordsPerSegment = maxNumRecordsPerSegment;
            return this;
        }

        public Builder setSegmentNamePrefix(String segmentNamePrefix) {
            this._segmentNamePrefix = segmentNamePrefix;
            return this;
        }

        public Builder setSegmentNamePostfix(String segmentNamePostfix) {
            this._segmentNamePostfix = segmentNamePostfix;
            return this;
        }

        public Builder setFixedSegmentName(String fixedSegmentName) {
            this._fixedSegmentName = fixedSegmentName;
            return this;
        }

        public Builder setIntermediateFileSizeThreshold(long segmentMapperFileSizeThresholdInBytes) {
            this._segmentMapperFileSizeThresholdInBytes = segmentMapperFileSizeThresholdInBytes;
            return this;
        }

        public SegmentConfig build() {
            Preconditions.checkState((this._maxNumRecordsPerSegment > 0 ? 1 : 0) != 0, (Object)"Max num records per segment must be > 0");
            Preconditions.checkState((this._segmentMapperFileSizeThresholdInBytes > 0L ? 1 : 0) != 0, (Object)"Intermediate file size threshold must be > 0");
            return new SegmentConfig(this._maxNumRecordsPerSegment, this._segmentNamePrefix, this._segmentNamePostfix, this._fixedSegmentName, this._segmentMapperFileSizeThresholdInBytes);
        }
    }
}

