/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.genericrow;

import java.io.IOException;
import org.apache.pinot.core.segment.processing.genericrow.AdaptiveConstraintsWriter;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileWriter;
import org.apache.pinot.spi.data.readers.GenericRow;

public class AdaptiveSizeBasedWriter
implements AdaptiveConstraintsWriter<GenericRowFileWriter, GenericRow> {
    private final long _bytesLimit;
    private long _numBytesWritten;

    public AdaptiveSizeBasedWriter(long bytesLimit) {
        this._bytesLimit = bytesLimit;
        this._numBytesWritten = 0L;
    }

    public long getBytesLimit() {
        return this._bytesLimit;
    }

    public long getNumBytesWritten() {
        return this._numBytesWritten;
    }

    @Override
    public boolean canWrite() {
        return this._numBytesWritten < this._bytesLimit;
    }

    @Override
    public void write(GenericRowFileWriter writer, GenericRow row) throws IOException {
        this._numBytesWritten += writer.writeData(row);
    }
}

