/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree;

import it.unimi.dsi.fastutil.objects.ObjectBooleanPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.CompositePredicateEvaluator;
import org.apache.pinot.core.startree.plan.StarTreeProjectPlanNode;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Metadata;

public class StarTreeUtils {
    private StarTreeUtils() {
    }

    @Nullable
    public static AggregationFunctionColumnPair[] extractAggregationFunctionPairs(AggregationFunction[] aggregationFunctions) {
        int numAggregationFunctions = aggregationFunctions.length;
        AggregationFunctionColumnPair[] aggregationFunctionColumnPairs = new AggregationFunctionColumnPair[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunctionColumnPair aggregationFunctionColumnPair = AggregationFunctionUtils.getStoredFunctionColumnPair(aggregationFunctions[i]);
            if (aggregationFunctionColumnPair == null) {
                return null;
            }
            aggregationFunctionColumnPairs[i] = aggregationFunctionColumnPair;
        }
        return aggregationFunctionColumnPairs;
    }

    @Nullable
    public static Map<String, List<CompositePredicateEvaluator>> extractPredicateEvaluatorsMap(IndexSegment indexSegment, @Nullable FilterContext filter, List<Pair<Predicate, PredicateEvaluator>> predicateEvaluatorMapping) {
        FilterContext filterNode;
        if (filter == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<CompositePredicateEvaluator>> predicateEvaluatorsMap = new HashMap<String, List<CompositePredicateEvaluator>>();
        ArrayDeque<FilterContext> queue = new ArrayDeque<FilterContext>();
        queue.add(filter);
        block6: while ((filterNode = (FilterContext)queue.poll()) != null) {
            switch (filterNode.getType()) {
                case AND: {
                    queue.addAll(filterNode.getChildren());
                    continue block6;
                }
                case OR: {
                    Pair<String, CompositePredicateEvaluator> pair = StarTreeUtils.isOrClauseValidForStarTree(indexSegment, filterNode, predicateEvaluatorMapping);
                    if (pair == null) {
                        return null;
                    }
                    if (pair.getLeft() == null) continue block6;
                    predicateEvaluatorsMap.computeIfAbsent((String)pair.getLeft(), k -> new ArrayList()).add((CompositePredicateEvaluator)pair.getRight());
                    continue block6;
                }
                case NOT: {
                    boolean negated = true;
                    FilterContext negatedChild = (FilterContext)filterNode.getChildren().get(0);
                    while (true) {
                        FilterContext.Type type;
                        if ((type = negatedChild.getType()) == FilterContext.Type.PREDICATE) {
                            Predicate predicate = negatedChild.getPredicate();
                            PredicateEvaluator predicateEvaluator = StarTreeUtils.getPredicateEvaluator(indexSegment, predicate, predicateEvaluatorMapping);
                            if (predicateEvaluator == null) {
                                return null;
                            }
                            if (predicateEvaluator.isAlwaysTrue() && negated || predicateEvaluator.isAlwaysFalse() && !negated) {
                                return null;
                            }
                            if (predicateEvaluator.isAlwaysTrue() && !negated || predicateEvaluator.isAlwaysFalse() && negated) continue block6;
                            predicateEvaluatorsMap.computeIfAbsent(predicate.getLhs().getIdentifier(), k -> new ArrayList()).add(new CompositePredicateEvaluator(List.of(ObjectBooleanPair.of((Object)predicateEvaluator, (boolean)negated))));
                            continue block6;
                        }
                        if (type != FilterContext.Type.NOT) break;
                        negated = !negated;
                        negatedChild = (FilterContext)negatedChild.getChildren().get(0);
                    }
                    return null;
                }
                case PREDICATE: {
                    Predicate predicate = filterNode.getPredicate();
                    PredicateEvaluator predicateEvaluator = StarTreeUtils.getPredicateEvaluator(indexSegment, predicate, predicateEvaluatorMapping);
                    if (predicateEvaluator == null || predicateEvaluator.isAlwaysFalse()) {
                        return null;
                    }
                    if (predicateEvaluator.isAlwaysTrue()) continue block6;
                    predicateEvaluatorsMap.computeIfAbsent(predicate.getLhs().getIdentifier(), k -> new ArrayList()).add(new CompositePredicateEvaluator(List.of(ObjectBooleanPair.of((Object)predicateEvaluator, (boolean)false))));
                    continue block6;
                }
            }
            throw new IllegalStateException();
        }
        return predicateEvaluatorsMap;
    }

    public static boolean isFitForStarTree(StarTreeV2Metadata starTreeV2Metadata, AggregationFunctionColumnPair[] aggregationFunctionColumnPairs, @Nullable ExpressionContext[] groupByExpressions, Set<String> predicateColumns) {
        for (AggregationFunctionColumnPair aggregationFunctionColumnPair : aggregationFunctionColumnPairs) {
            if (starTreeV2Metadata.containsFunctionColumnPair(aggregationFunctionColumnPair)) continue;
            return false;
        }
        HashSet starTreeDimensions = new HashSet(starTreeV2Metadata.getDimensionsSplitOrder());
        if (groupByExpressions != null) {
            HashSet groupByColumns = new HashSet();
            for (ExpressionContext groupByExpression : groupByExpressions) {
                groupByExpression.getColumns(groupByColumns);
            }
            if (!starTreeDimensions.containsAll(groupByColumns)) {
                return false;
            }
        }
        return starTreeDimensions.containsAll(predicateColumns);
    }

    @Nullable
    private static Pair<String, CompositePredicateEvaluator> isOrClauseValidForStarTree(IndexSegment indexSegment, FilterContext filter, List<Pair<Predicate, PredicateEvaluator>> predicateEvaluatorMapping) {
        assert (filter.getType() == FilterContext.Type.OR);
        ArrayList<ObjectBooleanPair<Predicate>> predicates = new ArrayList<ObjectBooleanPair<Predicate>>();
        if (!StarTreeUtils.extractOrClausePredicates(filter, predicates)) {
            return null;
        }
        String identifier = null;
        ArrayList<ObjectBooleanPair<PredicateEvaluator>> predicateEvaluators = new ArrayList<ObjectBooleanPair<PredicateEvaluator>>();
        for (ObjectBooleanPair objectBooleanPair : predicates) {
            PredicateEvaluator predicateEvaluator = StarTreeUtils.getPredicateEvaluator(indexSegment, (Predicate)objectBooleanPair.left(), predicateEvaluatorMapping);
            if (predicateEvaluator == null) {
                return null;
            }
            boolean negated = objectBooleanPair.rightBoolean();
            if (predicateEvaluator.isAlwaysTrue() && !negated || predicateEvaluator.isAlwaysFalse() && negated) {
                return Pair.of(null, null);
            }
            if (predicateEvaluator.isAlwaysTrue() && negated || predicateEvaluator.isAlwaysFalse() && !negated) continue;
            String predicateIdentifier = ((Predicate)objectBooleanPair.left()).getLhs().getIdentifier();
            if (identifier == null) {
                identifier = predicateIdentifier;
            } else if (!identifier.equals(predicateIdentifier)) {
                return null;
            }
            predicateEvaluators.add((ObjectBooleanPair<PredicateEvaluator>)ObjectBooleanPair.of((Object)predicateEvaluator, (boolean)negated));
        }
        if (predicateEvaluators.isEmpty()) {
            return null;
        }
        return Pair.of(identifier, (Object)new CompositePredicateEvaluator(predicateEvaluators));
    }

    private static boolean extractOrClausePredicates(FilterContext filter, List<ObjectBooleanPair<Predicate>> predicates) {
        assert (filter.getType() == FilterContext.Type.OR);
        block6: for (FilterContext child : filter.getChildren()) {
            switch (child.getType()) {
                case AND: {
                    return false;
                }
                case OR: {
                    if (StarTreeUtils.extractOrClausePredicates(child, predicates)) continue block6;
                    return false;
                }
                case NOT: {
                    boolean negated = true;
                    FilterContext negatedChild = (FilterContext)child.getChildren().get(0);
                    while (true) {
                        FilterContext.Type type;
                        if ((type = negatedChild.getType()) == FilterContext.Type.PREDICATE) {
                            predicates.add((ObjectBooleanPair<Predicate>)ObjectBooleanPair.of((Object)negatedChild.getPredicate(), (boolean)negated));
                            continue block6;
                        }
                        if (type != FilterContext.Type.NOT) break;
                        negated = !negated;
                        negatedChild = (FilterContext)negatedChild.getChildren().get(0);
                    }
                    return false;
                }
                case PREDICATE: {
                    predicates.add((ObjectBooleanPair<Predicate>)ObjectBooleanPair.of((Object)child.getPredicate(), (boolean)false));
                    continue block6;
                }
            }
            throw new IllegalStateException();
        }
        return true;
    }

    @Nullable
    private static PredicateEvaluator getPredicateEvaluator(IndexSegment indexSegment, Predicate predicate, List<Pair<Predicate, PredicateEvaluator>> predicatesEvaluatorMapping) {
        ExpressionContext lhs = predicate.getLhs();
        if (lhs.getType() != ExpressionContext.Type.IDENTIFIER) {
            return null;
        }
        String column = lhs.getIdentifier();
        DataSource dataSource = indexSegment.getDataSource(column);
        Dictionary dictionary = dataSource.getDictionary();
        if (dictionary == null) {
            return null;
        }
        switch (predicate.getType()) {
            case REGEXP_LIKE: 
            case TEXT_MATCH: 
            case IS_NULL: 
            case IS_NOT_NULL: {
                return null;
            }
        }
        for (Pair<Predicate, PredicateEvaluator> pair : predicatesEvaluatorMapping) {
            if (pair.getKey() != predicate) continue;
            return (PredicateEvaluator)pair.getValue();
        }
        return null;
    }

    @Nullable
    public static BaseProjectOperator<?> createStarTreeBasedProjectOperator(IndexSegment indexSegment, QueryContext queryContext, AggregationFunction[] aggregationFunctions, @Nullable FilterContext filter, List<Pair<Predicate, PredicateEvaluator>> predicateEvaluators) {
        List starTrees = indexSegment.getStarTrees();
        if (starTrees == null || queryContext.isSkipStarTree() || queryContext.isNullHandlingEnabled()) {
            return null;
        }
        AggregationFunctionColumnPair[] aggregationFunctionColumnPairs = StarTreeUtils.extractAggregationFunctionPairs(aggregationFunctions);
        if (aggregationFunctionColumnPairs == null) {
            return null;
        }
        Map<String, List<CompositePredicateEvaluator>> predicateEvaluatorsMap = StarTreeUtils.extractPredicateEvaluatorsMap(indexSegment, filter, predicateEvaluators);
        if (predicateEvaluatorsMap == null) {
            return null;
        }
        ExpressionContext[] groupByExpressions = queryContext.getGroupByExpressions() != null ? queryContext.getGroupByExpressions().toArray(new ExpressionContext[0]) : null;
        for (StarTreeV2 starTreeV2 : starTrees) {
            if (!StarTreeUtils.isFitForStarTree(starTreeV2.getMetadata(), aggregationFunctionColumnPairs, groupByExpressions, predicateEvaluatorsMap.keySet())) continue;
            return new StarTreeProjectPlanNode(queryContext, starTreeV2, aggregationFunctionColumnPairs, groupByExpressions, predicateEvaluatorsMap).run();
        }
        return null;
    }
}

