/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.executor;

import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.aggregation.DefaultAggregationExecutor;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;

public class StarTreeAggregationExecutor
extends DefaultAggregationExecutor {
    private final AggregationFunctionColumnPair[] _aggregationFunctionColumnPairs;

    public StarTreeAggregationExecutor(AggregationFunction[] aggregationFunctions) {
        super(aggregationFunctions);
        int numAggregationFunctions = aggregationFunctions.length;
        this._aggregationFunctionColumnPairs = new AggregationFunctionColumnPair[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            this._aggregationFunctionColumnPairs[i] = AggregationFunctionUtils.getStoredFunctionColumnPair(aggregationFunctions[i]);
        }
    }

    @Override
    public void aggregate(ValueBlock valueBlock) {
        int numAggregationFunctions = this._aggregationFunctions.length;
        int length = valueBlock.getNumDocs();
        for (int i = 0; i < numAggregationFunctions; ++i) {
            this._aggregationFunctions[i].aggregate(length, this._aggregationResultHolders[i], AggregationFunctionUtils.getBlockValSetMap(this._aggregationFunctionColumnPairs[i], valueBlock));
        }
    }
}

