/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.executor;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.blocks.ValueBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.aggregation.groupby.DefaultGroupByExecutor;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;

public class StarTreeGroupByExecutor
extends DefaultGroupByExecutor {
    private final AggregationFunctionColumnPair[] _aggregationFunctionColumnPairs;

    public StarTreeGroupByExecutor(QueryContext queryContext, ExpressionContext[] groupByExpressions, BaseProjectOperator<?> projectOperator) {
        this(queryContext, queryContext.getAggregationFunctions(), groupByExpressions, projectOperator, null);
    }

    public StarTreeGroupByExecutor(QueryContext queryContext, AggregationFunction[] aggregationFunctions, ExpressionContext[] groupByExpressions, BaseProjectOperator<?> projectOperator) {
        this(queryContext, aggregationFunctions, groupByExpressions, projectOperator, null);
    }

    public StarTreeGroupByExecutor(QueryContext queryContext, AggregationFunction[] aggregationFunctions, ExpressionContext[] groupByExpressions, BaseProjectOperator<?> projectOperator, @Nullable GroupKeyGenerator groupKeyGenerator) {
        super(queryContext, aggregationFunctions, groupByExpressions, projectOperator, groupKeyGenerator);
        assert (aggregationFunctions != null);
        int numAggregationFunctions = aggregationFunctions.length;
        this._aggregationFunctionColumnPairs = new AggregationFunctionColumnPair[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            this._aggregationFunctionColumnPairs[i] = AggregationFunctionUtils.getStoredFunctionColumnPair(aggregationFunctions[i]);
        }
    }

    @Override
    protected void aggregate(ValueBlock valueBlock, int length, int functionIndex) {
        AggregationFunction aggregationFunction = this._aggregationFunctions[functionIndex];
        GroupByResultHolder groupByResultHolder = this._groupByResultHolders[functionIndex];
        Map<ExpressionContext, BlockValSet> blockValSetMap = AggregationFunctionUtils.getBlockValSetMap(this._aggregationFunctionColumnPairs[functionIndex], valueBlock);
        if (this._hasMVGroupByExpression) {
            aggregationFunction.aggregateGroupByMV(length, this._mvGroupKeys, groupByResultHolder, blockValSetMap);
        } else {
            aggregationFunction.aggregateGroupBySV(length, this._svGroupKeys, groupByResultHolder, blockValSetMap);
        }
    }
}

