/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.plan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.operator.BaseProjectOperator;
import org.apache.pinot.core.operator.DocIdSetOperator;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.ProjectionOperatorUtils;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.CompositePredicateEvaluator;
import org.apache.pinot.core.startree.plan.StarTreeDocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;

public class StarTreeProjectPlanNode
implements PlanNode {
    private final QueryContext _queryContext;
    private final StarTreeV2 _starTreeV2;
    private final AggregationFunctionColumnPair[] _aggregationFunctionColumnPairs;
    private final ExpressionContext[] _groupByExpressions;
    private final Map<String, List<CompositePredicateEvaluator>> _predicateEvaluatorsMap;

    public StarTreeProjectPlanNode(QueryContext queryContext, StarTreeV2 starTreeV2, AggregationFunctionColumnPair[] aggregationFunctionColumnPairs, @Nullable ExpressionContext[] groupByExpressions, Map<String, List<CompositePredicateEvaluator>> predicateEvaluatorsMap) {
        this._queryContext = queryContext;
        this._starTreeV2 = starTreeV2;
        this._aggregationFunctionColumnPairs = aggregationFunctionColumnPairs;
        this._groupByExpressions = groupByExpressions;
        this._predicateEvaluatorsMap = predicateEvaluatorsMap;
    }

    public BaseProjectOperator<?> run() {
        HashSet<String> groupByColumns;
        HashSet<String> projectionColumns = new HashSet<String>();
        boolean hasNonIdentifierExpression = false;
        for (AggregationFunctionColumnPair aggregationFunctionColumnPair : this._aggregationFunctionColumnPairs) {
            projectionColumns.add(aggregationFunctionColumnPair.toColumnName());
        }
        if (this._groupByExpressions != null) {
            groupByColumns = new HashSet<String>();
            for (ExpressionContext expression : this._groupByExpressions) {
                expression.getColumns(groupByColumns);
                if (expression.getType() == ExpressionContext.Type.IDENTIFIER) continue;
                hasNonIdentifierExpression = true;
            }
            projectionColumns.addAll(groupByColumns);
        } else {
            groupByColumns = null;
        }
        DocIdSetOperator docIdSetOperator = new StarTreeDocIdSetPlanNode(this._queryContext, this._starTreeV2, this._predicateEvaluatorsMap, groupByColumns).run();
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(HashUtil.getHashMapCapacity((int)projectionColumns.size()));
        projectionColumns.forEach(column -> dataSourceMap.put((String)column, this._starTreeV2.getDataSource(column)));
        ProjectionOperator projectionOperator = ProjectionOperatorUtils.getProjectionOperator(dataSourceMap, docIdSetOperator);
        return hasNonIdentifierExpression ? new TransformOperator(this._queryContext, projectionOperator, Arrays.asList(this._groupByExpressions)) : projectionOperator;
    }
}

