/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.tls.TlsUtils;
import org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.core.transport.DataTableHandler;
import org.apache.pinot.core.transport.DirectOOMHandler;
import org.apache.pinot.core.transport.InstanceRequestHandler;
import org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.core.transport.ServerChannels;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.server.access.AccessControl;
import org.apache.pinot.spi.env.PinotConfiguration;

public class ChannelHandlerFactory {
    public static final String SSL = "ssl";
    private static final Map<Integer, SslContext> CLIENT_SSL_CONTEXTS_CACHE = new ConcurrentHashMap<Integer, SslContext>();
    private static final Map<Integer, SslContext> SERVER_SSL_CONTEXTS_CACHE = new ConcurrentHashMap<Integer, SslContext>();

    private ChannelHandlerFactory() {
    }

    public static ChannelHandler getLengthFieldBasedFrameDecoder() {
        return new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4);
    }

    public static ChannelHandler getLengthFieldPrepender() {
        return new LengthFieldPrepender(4);
    }

    public static ChannelHandler getClientTlsHandler(TlsConfig tlsConfig, SocketChannel ch) {
        SslContext sslContext = CLIENT_SSL_CONTEXTS_CACHE.computeIfAbsent(tlsConfig.hashCode(), tlsConfigHashCode -> TlsUtils.buildClientContext((TlsConfig)tlsConfig));
        return sslContext.newHandler(ch.alloc());
    }

    public static ChannelHandler getServerTlsHandler(TlsConfig tlsConfig, SocketChannel ch) {
        SslContext sslContext = SERVER_SSL_CONTEXTS_CACHE.computeIfAbsent(tlsConfig.hashCode(), tlsConfigHashCode -> TlsUtils.buildServerContext((TlsConfig)tlsConfig));
        return sslContext.newHandler(ch.alloc());
    }

    public static ChannelHandler getDataTableHandler(QueryRouter queryRouter, ServerRoutingInstance serverRoutingInstance, BrokerMetrics brokerMetrics) {
        return new DataTableHandler(queryRouter, serverRoutingInstance, brokerMetrics);
    }

    public static ChannelHandler getInstanceRequestHandler(String instanceName, PinotConfiguration config, QueryScheduler queryScheduler, ServerMetrics serverMetrics, AccessControl accessControl) {
        return new InstanceRequestHandler(instanceName, config, queryScheduler, serverMetrics, accessControl);
    }

    public static ChannelHandler getDirectOOMHandler(QueryRouter queryRouter, ServerRoutingInstance serverRoutingInstance, ConcurrentHashMap<ServerRoutingInstance, ServerChannels.ServerChannel> serverToChannelMap) {
        return new DirectOOMHandler(queryRouter, serverRoutingInstance, serverToChannelMap);
    }
}

