/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.core.transport.ServerChannels;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.exception.QueryCancelledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectOOMHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectOOMHandler.class);
    private static final AtomicBoolean DIRECT_OOM_SHUTTING_DOWN = new AtomicBoolean(false);
    private final QueryRouter _queryRouter;
    private final ServerRoutingInstance _serverRoutingInstance;
    private final ConcurrentHashMap<ServerRoutingInstance, ServerChannels.ServerChannel> _serverToChannelMap;
    private volatile boolean _silentShutDown = false;

    public DirectOOMHandler(QueryRouter queryRouter, ServerRoutingInstance serverRoutingInstance, ConcurrentHashMap<ServerRoutingInstance, ServerChannels.ServerChannel> serverToChannelMap) {
        this._queryRouter = queryRouter;
        this._serverRoutingInstance = serverRoutingInstance;
        this._serverToChannelMap = serverToChannelMap;
    }

    public void setSilentShutDown() {
        this._silentShutDown = true;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this._silentShutDown) {
            return;
        }
        ctx.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof OutOfMemoryError && StringUtils.containsIgnoreCase((CharSequence)cause.getMessage(), (CharSequence)"direct buffer")) {
            BrokerMetrics.get().addMeteredGlobalValue((AbstractMetrics.Meter)BrokerMeter.DIRECT_MEMORY_OOM, 1L);
            if (DIRECT_OOM_SHUTTING_DOWN.compareAndSet(false, true)) {
                try {
                    LOGGER.error("Closing ALL channels to servers, as we are running out of direct memory while receiving response from {}", (Object)this._serverRoutingInstance, (Object)cause);
                    ((ConcurrentHashMap.KeySetView)this._serverToChannelMap.keySet()).forEach(serverRoutingInstance -> {
                        ServerChannels.ServerChannel removed = this._serverToChannelMap.remove(serverRoutingInstance);
                        removed.closeChannel();
                        removed.setSilentShutdown();
                    });
                    this._queryRouter.markServerDown(this._serverRoutingInstance, (Exception)new QueryCancelledException("Query cancelled as broker is out of direct memory"));
                }
                catch (Exception e) {
                    LOGGER.error("Caught exception while handling direct memory OOM", (Throwable)e);
                }
                finally {
                    DIRECT_OOM_SHUTTING_DOWN.set(false);
                }
            } else {
                LOGGER.warn("Caught direct memory OOM, but another thread is already handling it", cause);
            }
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }
}

