/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsCheck {
    private static final OSType DETECTED_OS;
    private static final Logger LOGGER;

    private OsCheck() {
    }

    public static OSType getOperatingSystemType() {
        return DETECTED_OS;
    }

    static {
        LOGGER = LoggerFactory.getLogger(OsCheck.class);
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        LOGGER.info("System property \"os.name\" is: {}", (Object)os);
        DETECTED_OS = os.contains("mac") || os.contains("darwin") ? OSType.MacOS : (os.contains("win") ? OSType.Windows : (os.contains("linux") ? OSType.Linux : OSType.Other));
    }

    public static enum OSType {
        Windows,
        MacOS,
        Linux,
        Other;

    }
}

