/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixManager;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.spi.utils.StringUtil;
import org.apache.pinot.spi.utils.retry.AttemptsExceededException;
import org.apache.pinot.spi.utils.retry.RetryPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerServerSegmentFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerServerSegmentFinder.class);
    private static final int MAX_NUM_ATTEMPTS = 5;
    private static final int INITIAL_DELAY_MS = 500;
    private static final double DELAY_SCALE_FACTOR = 2.0;

    private PeerServerSegmentFinder() {
    }

    public static List<URI> getPeerServerURIs(HelixManager helixManager, String tableNameWithType, String segmentName, String downloadScheme) {
        HelixAdmin helixAdmin = helixManager.getClusterManagmentTool();
        String clusterName = helixManager.getClusterName();
        ArrayList<URI> onlineServerURIs = new ArrayList<URI>();
        try {
            RetryPolicies.exponentialBackoffRetryPolicy((int)5, (long)500L, (double)2.0).attempt(() -> {
                PeerServerSegmentFinder.getOnlineServersFromExternalView(helixAdmin, clusterName, tableNameWithType, segmentName, downloadScheme, onlineServerURIs);
                return !onlineServerURIs.isEmpty();
            });
        }
        catch (AttemptsExceededException e) {
            LOGGER.error("Failed to find ONLINE servers for segment: {} in table: {} after {} attempts", new Object[]{segmentName, tableNameWithType, 5});
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while getting peer server URIs for segment: {} in table: {}", new Object[]{segmentName, tableNameWithType, e});
        }
        return onlineServerURIs;
    }

    private static void getOnlineServersFromExternalView(HelixAdmin helixAdmin, String clusterName, String tableNameWithType, String segmentName, String downloadScheme, List<URI> onlineServerURIs) throws Exception {
        ExternalView externalView = helixAdmin.getResourceExternalView(clusterName, tableNameWithType);
        if (externalView == null) {
            LOGGER.warn("Failed to find external view for table: {}", (Object)tableNameWithType);
            return;
        }
        Map instanceStateMap = externalView.getStateMap(segmentName);
        if (instanceStateMap == null) {
            LOGGER.warn("Failed to find segment: {} in table: {}", (Object)segmentName, (Object)tableNameWithType);
            return;
        }
        for (Map.Entry instanceState : instanceStateMap.entrySet()) {
            if (!"ONLINE".equals(instanceState.getValue())) continue;
            String instanceId = (String)instanceState.getKey();
            LOGGER.info("Found ONLINE server: {} for segment: {} in table: {}", new Object[]{instanceId, segmentName, tableNameWithType});
            InstanceConfig instanceConfig = helixAdmin.getInstanceConfig(clusterName, instanceId);
            String hostName = instanceConfig.getHostName();
            String adminPortKey = PeerServerSegmentFinder.getAdminPortKey(downloadScheme);
            int port = instanceConfig.getRecord().getIntField(adminPortKey, 8097);
            onlineServerURIs.add(new URI(StringUtil.join((String)"/", (String[])new String[]{downloadScheme + "://" + hostName + ":" + port, "segments", tableNameWithType, segmentName})));
        }
    }

    private static String getAdminPortKey(String downloadScheme) {
        switch (downloadScheme) {
            case "http": {
                return "adminPort";
            }
            case "https": {
                return "adminHttpsPort";
            }
        }
        throw new IllegalArgumentException("Unsupported download scheme: " + downloadScheme);
    }
}

