/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.pinot.core.util.trace.TraceCallable;

public class QueryMultiThreadingUtils {
    public static final int MAX_NUM_THREADS_PER_QUERY = Math.max(1, Math.min(10, Runtime.getRuntime().availableProcessors() / 2));

    private QueryMultiThreadingUtils() {
    }

    public static int getNumTasksForQuery(int numOperators, int maxExecutionThreads) {
        return QueryMultiThreadingUtils.getNumTasks(numOperators, 1, maxExecutionThreads);
    }

    public static int getNumTasks(int numWorkUnits, int minUnitsPerThread, int maxExecutionThreads) {
        if (numWorkUnits <= minUnitsPerThread) {
            return 1;
        }
        if (maxExecutionThreads <= 0) {
            maxExecutionThreads = MAX_NUM_THREADS_PER_QUERY;
        }
        return Math.min((numWorkUnits + minUnitsPerThread - 1) / minUnitsPerThread, maxExecutionThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void runTasksWithDeadline(int numTasks, final Function<Integer, T> taskFunc, Consumer<T> resCollector, Consumer<Exception> errHandler, ExecutorService executorService, long deadlineInMs) {
        final Phaser phaser = new Phaser(1);
        ArrayList futures = new ArrayList(numTasks);
        int i = 0;
        while (i < numTasks) {
            final int n = i++;
            futures.add(executorService.submit(new TraceCallable<T>(){

                @Override
                public T callJob() {
                    try {
                        if (phaser.register() < 0) {
                            Object t = null;
                            return t;
                        }
                        Object r = taskFunc.apply(n);
                        return r;
                    }
                    finally {
                        phaser.arriveAndDeregister();
                    }
                }
            }));
        }
        try {
            for (Future future : futures) {
                Object taskResult = future.get(deadlineInMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                resCollector.accept(taskResult);
            }
        }
        catch (Exception e) {
            errHandler.accept(e);
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            phaser.awaitAdvance(phaser.arriveAndDeregister());
        }
    }
}

