/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util.trace;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.pinot.spi.utils.JsonUtils;

public final class TraceContext {
    private static final ThreadLocal<TraceEntry> TRACE_ENTRY_THREAD_LOCAL = new ThreadLocal<TraceEntry>(){

        @Override
        protected TraceEntry initialValue() {
            return null;
        }
    };
    @VisibleForTesting
    static final Map<Long, Queue<Trace>> REQUEST_TO_TRACES_MAP = new ConcurrentHashMap<Long, Queue<Trace>>();

    private TraceContext() {
    }

    public static void register(long requestId) {
        REQUEST_TO_TRACES_MAP.put(requestId, new ConcurrentLinkedQueue());
        TraceContext.registerThreadToRequest(new TraceEntry(requestId, null));
    }

    static void registerThreadToRequest(TraceEntry parentTraceEntry) {
        Trace trace = new Trace(parentTraceEntry._trace);
        TRACE_ENTRY_THREAD_LOCAL.set(new TraceEntry(parentTraceEntry._requestId, trace));
        Queue<Trace> traces = REQUEST_TO_TRACES_MAP.get(parentTraceEntry._requestId);
        if (traces != null) {
            traces.add(trace);
        }
    }

    public static void unregister() {
        TraceEntry traceEntry = TRACE_ENTRY_THREAD_LOCAL.get();
        REQUEST_TO_TRACES_MAP.remove(traceEntry._requestId);
        TraceContext.unregisterThreadFromRequest();
    }

    static void unregisterThreadFromRequest() {
        TRACE_ENTRY_THREAD_LOCAL.remove();
    }

    public static boolean traceEnabled() {
        return TRACE_ENTRY_THREAD_LOCAL.get() != null;
    }

    public static void logTime(String operatorName, long timeMs) {
        TraceContext.TRACE_ENTRY_THREAD_LOCAL.get()._trace.log(operatorName + " Time", timeMs);
    }

    public static void logInfo(String key, Object value) {
        TraceContext.TRACE_ENTRY_THREAD_LOCAL.get()._trace.log(key, value);
    }

    public static String getTraceInfo() {
        ArrayNode jsonTraces = JsonUtils.newArrayNode();
        Queue<Trace> traces = REQUEST_TO_TRACES_MAP.get(TraceContext.TRACE_ENTRY_THREAD_LOCAL.get()._requestId);
        if (traces != null && !traces.isEmpty()) {
            for (Trace trace : traces) {
                jsonTraces.add(trace.toJson());
            }
        }
        return jsonTraces.toString();
    }

    @Nullable
    static TraceEntry getTraceEntry() {
        return TRACE_ENTRY_THREAD_LOCAL.get();
    }

    static class TraceEntry {
        final long _requestId;
        final Trace _trace;

        TraceEntry(long requestId, Trace trace) {
            this._requestId = requestId;
            this._trace = trace;
        }
    }

    static class Trace {
        final String _traceId;
        final List<LogEntry> _logs = new ArrayList<LogEntry>();
        final AtomicInteger _numChildren = new AtomicInteger(0);

        Trace(@Nullable Trace parent) {
            this._traceId = parent == null ? "0" : parent.getChildTraceId();
        }

        void log(String key, Object value) {
            this._logs.add(new LogEntry(key, value));
        }

        String getChildTraceId() {
            return this._traceId + "_" + this._numChildren.getAndIncrement();
        }

        JsonNode toJson() {
            ArrayNode jsonLogs = JsonUtils.newArrayNode();
            for (LogEntry log : this._logs) {
                jsonLogs.add(log.toJson());
            }
            return JsonUtils.newObjectNode().set(this._traceId, (JsonNode)jsonLogs);
        }

        static class LogEntry {
            final String _key;
            final Object _value;

            LogEntry(String key, Object value) {
                this._key = key;
                this._value = value;
            }

            JsonNode toJson() {
                return JsonUtils.newObjectNode().set(this._key, JsonUtils.objectToJsonNode((Object)this._value));
            }
        }
    }
}

