/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.realtime;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.utils.ClientSSLContextGenerator;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.http.HttpClientConfig;
import org.apache.pinot.core.data.manager.realtime.Server2ControllerSegmentUploader;
import org.apache.pinot.core.util.SegmentCompletionProtocolUtils;
import org.apache.pinot.server.realtime.ControllerLeaderLocator;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSegmentCompletionProtocolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSegmentCompletionProtocolHandler.class);
    private static final String HTTPS_PROTOCOL = "https";
    private static final String HTTP_PROTOCOL = "http";
    private static SSLContext _sslContext;
    private static HttpClientConfig _httpClientConfig;
    private static Integer _controllerHttpsPort;
    private static int _segmentUploadRequestTimeoutMs;
    private static AuthProvider _authProvider;
    private static String _protocol;
    private final FileUploadDownloadClient _fileUploadDownloadClient = new FileUploadDownloadClient(_httpClientConfig, _sslContext);
    private final ServerMetrics _serverMetrics;
    private final String _rawTableName;

    public static void init(PinotConfiguration uploaderConfig) {
        PinotConfiguration httpsConfig = uploaderConfig.subset(HTTPS_PROTOCOL);
        if (httpsConfig.getProperty("enabled", false)) {
            _sslContext = new ClientSSLContextGenerator(httpsConfig.subset("ssl")).generate();
            _controllerHttpsPort = (Integer)httpsConfig.getProperty("controller.port", Integer.class);
        }
        _protocol = uploaderConfig.getProperty("protocol", HTTP_PROTOCOL);
        _segmentUploadRequestTimeoutMs = uploaderConfig.getProperty("upload.request.timeout.ms", 300000);
        _authProvider = AuthProviderUtils.extractAuthProvider((PinotConfiguration)uploaderConfig, (String)"auth");
        _httpClientConfig = HttpClientConfig.newBuilder((PinotConfiguration)uploaderConfig).build();
    }

    public ServerSegmentCompletionProtocolHandler(ServerMetrics serverMetrics, String tableNameWithType) {
        this._serverMetrics = serverMetrics;
        this._rawTableName = TableNameBuilder.extractRawTableName((String)tableNameWithType);
    }

    public static int getSegmentUploadRequestTimeoutMs() {
        return _segmentUploadRequestTimeoutMs;
    }

    public FileUploadDownloadClient getFileUploadDownloadClient() {
        return this._fileUploadDownloadClient;
    }

    public AuthProvider getAuthProvider() {
        return _authProvider;
    }

    public SegmentCompletionProtocol.Response segmentCommitStart(SegmentCompletionProtocol.Request.Params params) {
        SegmentCompletionProtocol.SegmentCommitStartRequest request = new SegmentCompletionProtocol.SegmentCommitStartRequest(params);
        String url = this.createSegmentCompletionUrl((SegmentCompletionProtocol.Request)request);
        if (url == null) {
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return this.sendRequest(url);
    }

    public String getSegmentCommitUploadURL(SegmentCompletionProtocol.Request.Params params, String controllerVipUrl) {
        String hostPort;
        String protocol;
        SegmentCompletionProtocol.SegmentCommitUploadRequest request = new SegmentCompletionProtocol.SegmentCommitUploadRequest(params);
        try {
            URI uri = URI.create(controllerVipUrl);
            protocol = uri.getScheme();
            hostPort = uri.getAuthority();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not make URI", e);
        }
        return request.getUrl(hostPort, protocol);
    }

    public SegmentCompletionProtocol.Response segmentCommitEndWithMetadata(SegmentCompletionProtocol.Request.Params params, Map<String, File> metadataFiles) {
        SegmentCompletionProtocol.SegmentCommitEndWithMetadataRequest request = new SegmentCompletionProtocol.SegmentCommitEndWithMetadataRequest(params);
        String url = this.createSegmentCompletionUrl((SegmentCompletionProtocol.Request)request);
        if (url == null) {
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return this.sendCommitEndWithMetadataFiles(url, metadataFiles);
    }

    public SegmentCompletionProtocol.Response segmentCommit(SegmentCompletionProtocol.Request.Params params, File segmentTarFile) {
        SegmentCompletionProtocol.SegmentCommitRequest request = new SegmentCompletionProtocol.SegmentCommitRequest(params);
        String url = this.createSegmentCompletionUrl((SegmentCompletionProtocol.Request)request);
        if (url == null) {
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        Server2ControllerSegmentUploader segmentUploader = null;
        try {
            segmentUploader = new Server2ControllerSegmentUploader(LOGGER, this._fileUploadDownloadClient, url, params.getSegmentName(), _segmentUploadRequestTimeoutMs, this._serverMetrics, _authProvider, this._rawTableName);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Segment commit upload url error: ", (Throwable)e);
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return segmentUploader.uploadSegmentToController(segmentTarFile);
    }

    public SegmentCompletionProtocol.Response extendBuildTime(SegmentCompletionProtocol.Request.Params params) {
        SegmentCompletionProtocol.ExtendBuildTimeRequest request = new SegmentCompletionProtocol.ExtendBuildTimeRequest(params);
        String url = this.createSegmentCompletionUrl((SegmentCompletionProtocol.Request)request);
        return this.sendRequest(url);
    }

    public SegmentCompletionProtocol.Response segmentConsumed(SegmentCompletionProtocol.Request.Params params) {
        SegmentCompletionProtocol.SegmentConsumedRequest request = new SegmentCompletionProtocol.SegmentConsumedRequest(params);
        String url = this.createSegmentCompletionUrl((SegmentCompletionProtocol.Request)request);
        if (url == null) {
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return this.sendRequest(url);
    }

    public SegmentCompletionProtocol.Response segmentStoppedConsuming(SegmentCompletionProtocol.Request.Params params) {
        SegmentCompletionProtocol.SegmentStoppedConsuming request = new SegmentCompletionProtocol.SegmentStoppedConsuming(params);
        String url = this.createSegmentCompletionUrl((SegmentCompletionProtocol.Request)request);
        if (url == null) {
            return SegmentCompletionProtocol.RESP_NOT_SENT;
        }
        return this.sendRequest(url);
    }

    private String createSegmentCompletionUrl(SegmentCompletionProtocol.Request request) {
        ControllerLeaderLocator leaderLocator = ControllerLeaderLocator.getInstance();
        Pair<String, Integer> leaderHostPort = leaderLocator.getControllerLeader(this._rawTableName);
        if (leaderHostPort == null) {
            LOGGER.warn("No leader found while trying to send {}", (Object)request.toString());
            return null;
        }
        Integer port = (Integer)leaderHostPort.getRight();
        String protocol = _protocol;
        if (_controllerHttpsPort != null) {
            port = _controllerHttpsPort;
            protocol = HTTPS_PROTOCOL;
        }
        return request.getUrl((String)leaderHostPort.getLeft() + ":" + port, protocol);
    }

    private SegmentCompletionProtocol.Response sendRequest(String url) {
        SegmentCompletionProtocol.Response response;
        try {
            String responseStr = this._fileUploadDownloadClient.sendSegmentCompletionProtocolRequest(new URI(url), AuthProviderUtils.toRequestHeaders((AuthProvider)_authProvider), null, 10000).getResponse();
            response = SegmentCompletionProtocol.Response.fromJsonString((String)responseStr);
            LOGGER.info("Controller response {} for {}", (Object)response.toJsonString(), (Object)url);
            if (response.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.NOT_LEADER)) {
                ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
            }
        }
        catch (Exception e) {
            response = SegmentCompletionProtocol.RESP_NOT_SENT;
            LOGGER.error("Could not send request {}", (Object)url, (Object)e);
            ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
        }
        SegmentCompletionProtocolUtils.raiseSegmentCompletionProtocolResponseMetric(this._serverMetrics, response);
        return response;
    }

    private SegmentCompletionProtocol.Response sendCommitEndWithMetadataFiles(String url, Map<String, File> metadataFiles) {
        SegmentCompletionProtocol.Response response;
        try {
            String responseStr = this._fileUploadDownloadClient.uploadSegmentMetadataFiles(new URI(url), metadataFiles, AuthProviderUtils.toRequestHeaders((AuthProvider)_authProvider), null, _segmentUploadRequestTimeoutMs).getResponse();
            response = SegmentCompletionProtocol.Response.fromJsonString((String)responseStr);
            LOGGER.info("Controller response {} for {}", (Object)response.toJsonString(), (Object)url);
            if (response.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.NOT_LEADER)) {
                ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
            }
        }
        catch (Exception e) {
            response = SegmentCompletionProtocol.RESP_NOT_SENT;
            LOGGER.error("Could not send request {}", (Object)url, (Object)e);
            ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
        }
        SegmentCompletionProtocolUtils.raiseSegmentCompletionProtocolResponseMetric(this._serverMetrics, response);
        return response;
    }

    static {
        _httpClientConfig = HttpClientConfig.DEFAULT_HTTP_CLIENT_CONFIG;
        _protocol = HTTP_PROTOCOL;
    }
}

