/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.s3.AmazonS3Client;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.trino.plugin.kinesis.KinesisClientProvider;
import io.trino.plugin.kinesis.KinesisConfig;

public class KinesisClientManager
implements KinesisClientProvider {
    private final AmazonKinesisClient client;
    private final AmazonS3Client amazonS3Client;
    private final AmazonDynamoDBClient dynamoDbClient;

    @Inject
    public KinesisClientManager(KinesisConfig config) {
        if (!Strings.isNullOrEmpty((String)config.getAccessKey()) && !Strings.isNullOrEmpty((String)config.getSecretKey())) {
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(config.getAccessKey(), config.getSecretKey());
            this.client = new AmazonKinesisClient((AWSCredentials)awsCredentials);
            this.amazonS3Client = new AmazonS3Client((AWSCredentials)awsCredentials);
            this.dynamoDbClient = new AmazonDynamoDBClient((AWSCredentials)awsCredentials);
        } else {
            DefaultAWSCredentialsProviderChain defaultChain = new DefaultAWSCredentialsProviderChain();
            this.client = new AmazonKinesisClient((AWSCredentialsProvider)defaultChain);
            this.amazonS3Client = new AmazonS3Client((AWSCredentialsProvider)defaultChain);
            this.dynamoDbClient = new AmazonDynamoDBClient((AWSCredentialsProvider)defaultChain);
        }
        this.client.setEndpoint("kinesis." + config.getAwsRegion() + ".amazonaws.com");
        this.dynamoDbClient.setEndpoint("dynamodb." + config.getAwsRegion() + ".amazonaws.com");
    }

    @Override
    public AmazonKinesisClient getClient() {
        return this.client;
    }

    @Override
    public AmazonDynamoDBClient getDynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public AmazonS3Client getS3Client() {
        return this.amazonS3Client;
    }
}

