/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class KinesisColumnHandle
implements DecoderColumnHandle {
    private final int ordinalPosition;
    private final String name;
    private final Type type;
    private final String mapping;
    private final String dataFormat;
    private final String formatHint;
    private final boolean hidden;
    private final boolean internal;

    @JsonCreator
    public KinesisColumnHandle(@JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="mapping") String mapping, @JsonProperty(value="dataFormat") String dataFormat, @JsonProperty(value="formatHint") String formatHint, @JsonProperty(value="hidden") boolean hidden, @JsonProperty(value="internal") boolean internal) {
        this.ordinalPosition = ordinalPosition;
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.mapping = mapping;
        this.dataFormat = dataFormat;
        this.formatHint = formatHint;
        this.hidden = hidden;
        this.internal = internal;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Nullable
    @JsonProperty
    public String getMapping() {
        return this.mapping;
    }

    @Nullable
    @JsonProperty
    public String getDataFormat() {
        return this.dataFormat;
    }

    @JsonProperty
    public String getFormatHint() {
        return this.formatHint;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    @JsonProperty
    public boolean isInternal() {
        return this.internal;
    }

    ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(this.name).setType(this.type).setHidden(this.hidden).build();
    }

    public int hashCode() {
        return Objects.hash(this.ordinalPosition, this.name, this.type, this.mapping, this.dataFormat, this.formatHint, this.hidden, this.internal);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KinesisColumnHandle other = (KinesisColumnHandle)obj;
        return this.ordinalPosition == other.ordinalPosition && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.mapping, other.mapping) && Objects.equals(this.dataFormat, other.dataFormat) && Objects.equals(this.formatHint, other.formatHint) && this.hidden == other.hidden && this.internal == other.internal;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ordinalPosition", this.ordinalPosition).add("name", (Object)this.name).add("type", (Object)this.type).add("mapping", (Object)this.mapping).add("dataFormat", (Object)this.dataFormat).add("formatHint", (Object)this.formatHint).add("hidden", this.hidden).add("internal", this.internal).toString();
    }
}

