/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.Shard;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import io.trino.plugin.kinesis.KinesisClientProvider;
import io.trino.plugin.kinesis.KinesisSplit;
import io.trino.plugin.kinesis.KinesisTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class KinesisSplitManager
implements ConnectorSplitManager {
    public static final long MAX_CACHE_AGE_MILLIS = new Duration(1.0, TimeUnit.DAYS).toMillis();
    private final KinesisClientProvider clientManager;
    private final Map<String, InternalStreamDescription> streamMap = Collections.synchronizedMap(new HashMap());

    @Inject
    public KinesisSplitManager(KinesisClientProvider clientManager) {
        this.clientManager = clientManager;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        KinesisTableHandle kinesisTableHandle = (KinesisTableHandle)table;
        InternalStreamDescription description = this.getStreamDescription(kinesisTableHandle.streamName());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Shard shard : description.getShards()) {
            KinesisSplit split = new KinesisSplit(kinesisTableHandle.streamName(), kinesisTableHandle.messageDataFormat(), kinesisTableHandle.compressionCodec(), shard.getShardId(), shard.getSequenceNumberRange().getStartingSequenceNumber(), shard.getSequenceNumberRange().getEndingSequenceNumber());
            builder.add((Object)split);
        }
        return new FixedSplitSource((Iterable)builder.build());
    }

    protected InternalStreamDescription getStreamDescription(String streamName) {
        InternalStreamDescription internalStreamDescription = this.streamMap.get(streamName);
        if (internalStreamDescription == null || System.currentTimeMillis() - internalStreamDescription.getCreateTimeStamp() >= MAX_CACHE_AGE_MILLIS) {
            DescribeStreamResult describeStreamResult;
            internalStreamDescription = new InternalStreamDescription(streamName);
            DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest();
            describeStreamRequest.setStreamName(streamName);
            String exclusiveStartShardId = null;
            ArrayList shards = new ArrayList();
            do {
                describeStreamRequest.setExclusiveStartShardId(exclusiveStartShardId);
                describeStreamResult = this.clientManager.getClient().describeStream(describeStreamRequest);
                String streamStatus = describeStreamResult.getStreamDescription().getStreamStatus();
                if (!streamStatus.equals("ACTIVE") && !streamStatus.equals("UPDATING")) {
                    throw new ResourceNotFoundException("Stream not Active");
                }
                internalStreamDescription.addAllShards(describeStreamResult.getStreamDescription().getShards());
            } while ((exclusiveStartShardId = describeStreamResult.getStreamDescription().getHasMoreShards() != false && shards.size() > 0 ? ((Shard)shards.getLast()).getShardId() : null) != null);
            this.streamMap.put(streamName, internalStreamDescription);
        }
        return internalStreamDescription;
    }

    public static class InternalStreamDescription {
        private final String streamName;
        private final List<Shard> shards = new ArrayList<Shard>();
        private final long createTimeStamp;

        public InternalStreamDescription(String streamName) {
            this.streamName = Objects.requireNonNull(streamName);
            this.createTimeStamp = System.currentTimeMillis();
        }

        public long getCreateTimeStamp() {
            return this.createTimeStamp;
        }

        public String getStreamName() {
            return this.streamName;
        }

        public List<Shard> getShards() {
            return this.shards;
        }

        public void addAllShards(List<Shard> shards) {
            this.shards.addAll(shards);
        }
    }
}

