/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kinesis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.trino.plugin.kinesis.KinesisColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public record KinesisStreamFieldDescription(String name, Type type, String mapping, String comment, String dataFormat, String formatHint, boolean hidden) {
    public KinesisStreamFieldDescription {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        Objects.requireNonNull(type, "type is null");
    }

    KinesisColumnHandle columnHandle(int index) {
        return new KinesisColumnHandle(index, this.name(), this.type(), this.mapping(), this.dataFormat(), this.formatHint(), this.hidden(), false);
    }

    ColumnMetadata columnMetadata() {
        return ColumnMetadata.builder().setName(this.name()).setType(this.type()).setComment(Optional.ofNullable(this.comment())).setHidden(this.hidden()).build();
    }
}

