/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf.path;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.path.PathConfiguration;
import alluxio.conf.path.PathMatcher;
import alluxio.conf.path.PrefixPathMatcher;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PrefixPathConfiguration
implements PathConfiguration {
    private final ConcurrentHashMap<String, AlluxioConfiguration> mConf = new ConcurrentHashMap();
    private final PathMatcher mMatcher;

    public PrefixPathConfiguration(Map<String, AlluxioConfiguration> configurations) {
        configurations.forEach((path, conf) -> this.mConf.put((String)path, (AlluxioConfiguration)conf));
        this.mMatcher = new PrefixPathMatcher(configurations.keySet());
    }

    @Override
    public Optional<AlluxioConfiguration> getConfiguration(AlluxioURI path, PropertyKey key) {
        Optional<List<String>> patterns = this.mMatcher.match(path);
        if (patterns.isPresent()) {
            for (String pattern : patterns.get()) {
                if (!this.mConf.get(pattern).isSetByUser(key)) continue;
                return Optional.of(this.mConf.get(pattern));
            }
        }
        return Optional.empty();
    }

    @Override
    public Set<PropertyKey> getPropertyKeys(AlluxioURI path) {
        HashSet<PropertyKey> keys = new HashSet<PropertyKey>();
        this.mMatcher.match(path).ifPresent(patterns -> patterns.forEach(pattern -> keys.addAll(this.mConf.get(pattern).userKeySet())));
        return keys;
    }
}

