/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.AlluxioResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakTracker;
import java.io.Closeable;
import javax.annotation.Nullable;

public abstract class CloseableResource<T>
implements Closeable {
    private static final ResourceLeakDetector<CloseableResource> DETECTOR = AlluxioResourceLeakDetectorFactory.instance().newResourceLeakDetector(CloseableResource.class);
    private final T mResource;
    @Nullable
    private final ResourceLeakTracker<CloseableResource> mTracker = DETECTOR.track((Object)this);

    public CloseableResource(T resource) {
        this.mResource = resource;
    }

    public T get() {
        return this.mResource;
    }

    @Override
    public void close() {
        if (this.mTracker != null) {
            this.mTracker.close((Object)this);
        }
        this.closeResource();
    }

    public abstract void closeResource();
}

