/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.transport.netty.client;

import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.Min;
import java.util.concurrent.TimeUnit;

public class DriftNettyConnectionFactoryConfig {
    private static final int DEFAULT_THREAD_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private int threadCount = DEFAULT_THREAD_COUNT;
    private boolean connectionPoolEnabled = true;
    private int connectionPoolMaxSize = 1000;
    private Duration connectionPoolIdleTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private Duration sslContextRefreshTime = new Duration(1.0, TimeUnit.MINUTES);
    private HostAndPort socksProxy;

    public int getThreadCount() {
        return this.threadCount;
    }

    @Config(value="thrift.client.thread-count")
    public DriftNettyConnectionFactoryConfig setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public boolean isConnectionPoolEnabled() {
        return this.connectionPoolEnabled;
    }

    @Config(value="thrift.client.connection-pool.enabled")
    public DriftNettyConnectionFactoryConfig setConnectionPoolEnabled(boolean connectionPoolEnabled) {
        this.connectionPoolEnabled = connectionPoolEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getConnectionPoolMaxSize() {
        return this.connectionPoolMaxSize;
    }

    @Config(value="thrift.client.connection-pool.max-size")
    public DriftNettyConnectionFactoryConfig setConnectionPoolMaxSize(int connectionPoolMaxSize) {
        this.connectionPoolMaxSize = connectionPoolMaxSize;
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getConnectionPoolIdleTimeout() {
        return this.connectionPoolIdleTimeout;
    }

    @Config(value="thrift.client.connection-pool.idle-timeout")
    public DriftNettyConnectionFactoryConfig setConnectionPoolIdleTimeout(Duration connectionPoolIdleTimeout) {
        this.connectionPoolIdleTimeout = connectionPoolIdleTimeout;
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getSslContextRefreshTime() {
        return this.sslContextRefreshTime;
    }

    @Config(value="thrift.client.ssl-context.refresh-time")
    public DriftNettyConnectionFactoryConfig setSslContextRefreshTime(Duration sslContextRefreshTime) {
        this.sslContextRefreshTime = sslContextRefreshTime;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="thrift.client.socks-proxy")
    public DriftNettyConnectionFactoryConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }
}

