/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.kafka;

import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.plugin.eventlistener.kafka.KafkaEventListenerConfig;
import io.trino.plugin.eventlistener.kafka.KafkaEventPublisher;
import io.trino.plugin.eventlistener.kafka.metrics.KafkaEventListenerJmxStats;
import io.trino.plugin.eventlistener.kafka.producer.KafkaProducerFactory;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.SplitCompletedEvent;
import javax.annotation.Nullable;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class KafkaEventListener
implements EventListener {
    private static final Logger LOG = Logger.get(KafkaEventListener.class);
    private final KafkaEventListenerJmxStats stats = new KafkaEventListenerJmxStats();
    private final boolean publishCreatedEvent;
    private final boolean publishCompletedEvent;
    private final boolean publishSplitCompletedEvent;
    private final boolean isAnonymizationEnabled;
    @Nullable
    private KafkaEventPublisher kafkaPublisher;

    @Inject
    public KafkaEventListener(KafkaEventListenerConfig config, KafkaProducerFactory producerFactory) throws Exception {
        this.publishCreatedEvent = config.getPublishCreatedEvent();
        this.publishCompletedEvent = config.getPublishCompletedEvent();
        this.publishSplitCompletedEvent = config.getPublishSplitCompletedEvent();
        this.isAnonymizationEnabled = config.isAnonymizationEnabled();
        try {
            if (this.publishCreatedEvent || this.publishCompletedEvent) {
                this.kafkaPublisher = new KafkaEventPublisher(config, producerFactory, this.stats);
            } else {
                LOG.warn("Event listener will be no-op, as neither created events nor completed events are published.");
            }
        }
        catch (Exception e) {
            if (config.getTerminateOnInitializationFailure()) {
                throw e;
            }
            LOG.error((Throwable)e, "Failed to initialize Kafka publisher.");
            this.stats.kafkaPublisherFailedToInitialize();
        }
    }

    @Managed
    @Flatten
    public KafkaEventListenerJmxStats getStats() {
        return this.stats;
    }

    public void queryCreated(QueryCreatedEvent event) {
        if (this.kafkaPublisher != null && this.publishCreatedEvent) {
            this.kafkaPublisher.publishCreatedEvent(event);
        }
    }

    public void queryCompleted(QueryCompletedEvent event) {
        if (this.kafkaPublisher != null && this.publishCompletedEvent) {
            this.kafkaPublisher.publishCompletedEvent(event);
        }
    }

    public void splitCompleted(SplitCompletedEvent event) {
        if (this.kafkaPublisher != null && this.publishSplitCompletedEvent) {
            this.kafkaPublisher.publishSplitCompletedEvent(event);
        }
    }

    public boolean requiresAnonymizedPlan() {
        return this.isAnonymizationEnabled;
    }

    public void shutdown() {
        if (this.kafkaPublisher != null) {
            this.kafkaPublisher.shutdown();
        }
    }
}

