/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.kafka;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class KafkaEventListenerConfig {
    private static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings().withKeyValueSeparator("=");
    private boolean anonymizationEnabled;
    private boolean publishCreatedEvent = true;
    private boolean publishCompletedEvent = true;
    private boolean publishSplitCompletedEvent;
    private Optional<String> completedTopicName = Optional.empty();
    private Optional<String> createdTopicName = Optional.empty();
    private Optional<String> splitCompletedTopicName = Optional.empty();
    private String brokerEndpoints;
    private Optional<String> clientId = Optional.empty();
    private Set<String> excludedFields = Collections.emptySet();
    private Map<String, String> kafkaClientOverrides = Collections.emptyMap();
    private Duration requestTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private boolean terminateOnInitializationFailure = true;
    private Optional<String> environmentVariablePrefix = Optional.empty();

    public boolean isAnonymizationEnabled() {
        return this.anonymizationEnabled;
    }

    @Config(value="kafka-event-listener.anonymization.enabled")
    public KafkaEventListenerConfig setAnonymizationEnabled(boolean anonymizationEnabled) {
        this.anonymizationEnabled = anonymizationEnabled;
        return this;
    }

    @NotEmpty
    public String getBrokerEndpoints() {
        return this.brokerEndpoints;
    }

    @Config(value="kafka-event-listener.broker-endpoints")
    public KafkaEventListenerConfig setBrokerEndpoints(String brokerEndpoints) {
        this.brokerEndpoints = brokerEndpoints;
        return this;
    }

    public Optional<String> getClientId() {
        return this.clientId;
    }

    @Config(value="kafka-event-listener.client-id")
    public KafkaEventListenerConfig setClientId(String clientId) {
        this.clientId = Optional.ofNullable(clientId);
        return this;
    }

    public Optional<String> getCompletedTopicName() {
        return this.completedTopicName;
    }

    @Config(value="kafka-event-listener.completed-event.topic")
    public KafkaEventListenerConfig setCompletedTopicName(String completedTopicName) {
        this.completedTopicName = Optional.ofNullable(completedTopicName);
        return this;
    }

    public Optional<String> getCreatedTopicName() {
        return this.createdTopicName;
    }

    @Config(value="kafka-event-listener.created-event.topic")
    public KafkaEventListenerConfig setCreatedTopicName(String createdTopicName) {
        this.createdTopicName = Optional.ofNullable(createdTopicName);
        return this;
    }

    public Optional<String> getSplitCompletedTopicName() {
        return this.splitCompletedTopicName;
    }

    @Config(value="kafka-event-listener.split-completed-event.topic")
    public KafkaEventListenerConfig setSplitCompletedTopicName(String splitCompletedTopicName) {
        this.splitCompletedTopicName = Optional.ofNullable(splitCompletedTopicName);
        return this;
    }

    public boolean getPublishCreatedEvent() {
        return this.publishCreatedEvent;
    }

    @ConfigDescription(value="Whether to publish io.trino.spi.eventlistener.QueryCreatedEvent")
    @Config(value="kafka-event-listener.publish-created-event")
    public KafkaEventListenerConfig setPublishCreatedEvent(boolean publishCreatedEvent) {
        this.publishCreatedEvent = publishCreatedEvent;
        return this;
    }

    public boolean getPublishCompletedEvent() {
        return this.publishCompletedEvent;
    }

    @ConfigDescription(value="Whether to publish io.trino.spi.eventlistener.QueryCompletedEvent")
    @Config(value="kafka-event-listener.publish-completed-event")
    public KafkaEventListenerConfig setPublishCompletedEvent(boolean publishCompletedEvent) {
        this.publishCompletedEvent = publishCompletedEvent;
        return this;
    }

    public boolean getPublishSplitCompletedEvent() {
        return this.publishSplitCompletedEvent;
    }

    @ConfigDescription(value="Whether to publish io.trino.spi.eventlistener.SplitCompletedEvent")
    @Config(value="kafka-event-listener.publish-split-completed-event")
    public KafkaEventListenerConfig setPublishSplitCompletedEvent(boolean publishSplitCompletedEvent) {
        this.publishSplitCompletedEvent = publishSplitCompletedEvent;
        return this;
    }

    public Set<String> getExcludedFields() {
        return this.excludedFields;
    }

    @ConfigDescription(value="Comma-separated list of field names to be excluded from the Kafka event (their value will be replaced with null). E.g.: 'payload,user'")
    @Config(value="kafka-event-listener.excluded-fields")
    public KafkaEventListenerConfig setExcludedFields(Set<String> excludedFields) {
        this.excludedFields = (Set)Objects.requireNonNull(excludedFields, "excludedFields is null").stream().filter(field -> !field.isBlank()).collect(ImmutableSet.toImmutableSet());
        return this;
    }

    public Map<String, String> getKafkaClientOverrides() {
        return this.kafkaClientOverrides;
    }

    @ConfigDescription(value="Comma-separated list of key-value pairs to specify kafka client config overrides. E.g.: 'buffer.memory=67108864,compression.type=zstd'")
    @Config(value="kafka-event-listener.client-config-overrides")
    public KafkaEventListenerConfig setKafkaClientOverrides(String kafkaClientOverrides) {
        this.kafkaClientOverrides = MAP_SPLITTER.split((CharSequence)Objects.requireNonNull(kafkaClientOverrides, "kafkaClientOverrides is null"));
        return this;
    }

    @MinDuration(value="1ms")
    public @MinDuration(value="1ms") Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @ConfigDescription(value="Timeout value to complete a kafka request.")
    @Config(value="kafka-event-listener.request-timeout")
    public KafkaEventListenerConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public boolean getTerminateOnInitializationFailure() {
        return this.terminateOnInitializationFailure;
    }

    @ConfigDescription(value="Kafka publisher initialization might fail due to network issues reaching the Kafka brokers. This flag controls whether to throw an exception in such cases.")
    @Config(value="kafka-event-listener.terminate-on-initialization-failure")
    public KafkaEventListenerConfig setTerminateOnInitializationFailure(boolean terminateOnInitializationFailure) {
        this.terminateOnInitializationFailure = terminateOnInitializationFailure;
        return this;
    }

    public Optional<String> getEnvironmentVariablePrefix() {
        return this.environmentVariablePrefix;
    }

    @ConfigDescription(value="When set, Kafka events will be sent with additional metadata populated from environment variables. E.g. if env-var-prefix is set to 'TRINO_INSIGHTS_' and there is an env var TRINO_INSIGHTS_CLUSTER_ID=foo, then Kafka payload metadata will contain CLUSTER_ID=foo.")
    @Config(value="kafka-event-listener.env-var-prefix")
    public KafkaEventListenerConfig setEnvironmentVariablePrefix(String environmentVariablePrefix) {
        this.environmentVariablePrefix = Optional.ofNullable(environmentVariablePrefix);
        return this;
    }

    @AssertTrue(message="Created topic name must be configured when publishing created events is enabled.")
    public @AssertTrue(message="Created topic name must be configured when publishing created events is enabled.") boolean isCreatedTopicNamePresent() {
        return !this.publishCreatedEvent || !this.createdTopicName.orElse("").isBlank();
    }

    @AssertTrue(message="Completed topic name must be configured when publishing completed events is enabled.")
    public @AssertTrue(message="Completed topic name must be configured when publishing completed events is enabled.") boolean isCompletedTopicNamePresent() {
        return !this.publishCompletedEvent || !this.completedTopicName.orElse("").isBlank();
    }

    @AssertTrue(message="Split completed topic name must be configured when publishing split completed events is enabled.")
    public @AssertTrue(message="Split completed topic name must be configured when publishing split completed events is enabled.") boolean isSplitCompletedTopicNamePresent() {
        return !this.publishSplitCompletedEvent || !this.splitCompletedTopicName.orElse("").isBlank();
    }
}

