/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.kafka;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.eventlistener.kafka.KafkaEventListener;
import io.trino.plugin.eventlistener.kafka.KafkaEventListenerConfig;
import io.trino.plugin.eventlistener.kafka.KafkaProducerModule;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.EventListenerFactory;
import java.util.Map;
import org.weakref.jmx.guice.ExportBinder;
import org.weakref.jmx.guice.MBeanModule;

public class KafkaEventListenerFactory
implements EventListenerFactory {
    public String getName() {
        return "kafka";
    }

    public EventListener create(Map<String, String> config, EventListenerFactory.EventListenerContext context) {
        Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new MBeanServerModule(), new KafkaProducerModule(), binder -> {
            binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry());
            ConfigBinder.configBinder((Binder)binder).bindConfig(KafkaEventListenerConfig.class);
            binder.bind(KafkaEventListener.class).in(Scopes.SINGLETON);
            ExportBinder.newExporter((Binder)binder).export(KafkaEventListener.class).withGeneratedName();
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (EventListener)injector.getInstance(KafkaEventListener.class);
    }
}

