/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.kafka;

import com.google.common.base.Preconditions;
import io.airlift.log.Logger;
import io.trino.plugin.eventlistener.kafka.KafkaEventListenerConfig;
import io.trino.plugin.eventlistener.kafka.KafkaRecordBuilder;
import io.trino.plugin.eventlistener.kafka.metadata.EnvMetadataProvider;
import io.trino.plugin.eventlistener.kafka.metadata.MetadataProvider;
import io.trino.plugin.eventlistener.kafka.metadata.NoOpMetadataProvider;
import io.trino.plugin.eventlistener.kafka.metrics.KafkaEventListenerJmxStats;
import io.trino.plugin.eventlistener.kafka.producer.KafkaProducerFactory;
import io.trino.plugin.eventlistener.kafka.producer.SSLKafkaProducerFactory;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.SplitCompletedEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.TimeoutException;

public class KafkaEventPublisher {
    private static final Logger LOG = Logger.get(KafkaEventPublisher.class);
    private final Producer<String, String> kafkaProducer;
    private final KafkaRecordBuilder kafkaRecordBuilder;
    private final KafkaEventListenerJmxStats stats;

    public KafkaEventPublisher(KafkaEventListenerConfig config, KafkaProducerFactory producerFactory, KafkaEventListenerJmxStats stats) throws Exception {
        this.stats = Objects.requireNonNull(stats, "stats cannot be null");
        Objects.requireNonNull(config, "config cannot be null");
        Objects.requireNonNull(producerFactory, "producerFactory cannot be null");
        Preconditions.checkArgument((config.getCreatedTopicName().isPresent() || config.getCompletedTopicName().isPresent() ? 1 : 0) != 0, (Object)"Either created or completed topic must be present");
        String createdTopic = config.getCreatedTopicName().orElse("");
        String completedTopic = config.getCompletedTopicName().orElse("");
        String splitCompletedTopic = config.getSplitCompletedTopicName().orElse("");
        Map<String, String> configOverrides = config.getKafkaClientOverrides();
        LOG.info("Creating Kafka publisher (SSL=%s) for topics: %s/%s with excluded fields: %s and kafka config overrides: %s", new Object[]{producerFactory instanceof SSLKafkaProducerFactory, createdTopic, completedTopic, config.getExcludedFields(), configOverrides});
        this.kafkaProducer = producerFactory.producer(configOverrides);
        this.checkConnectivityToBrokers(config.getPublishCreatedEvent() ? createdTopic : completedTopic, config.getRequestTimeout().toMillis());
        this.kafkaRecordBuilder = new KafkaRecordBuilder(createdTopic, completedTopic, splitCompletedTopic, config.getExcludedFields(), this.metadataProvider(config));
        LOG.info("Successfully created Kafka publisher.");
    }

    private void checkConnectivityToBrokers(String topic, long requestTimeout) throws Exception {
        LOG.info("checking connectivity to brokers (fetching partitions for topic=%s).", new Object[]{topic});
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.kafkaProducer.partitionsFor(topic));
        future.get(requestTimeout, TimeUnit.MILLISECONDS);
        LOG.info("connectivity check succeeded.");
    }

    private MetadataProvider metadataProvider(KafkaEventListenerConfig config) {
        if (config.getEnvironmentVariablePrefix().isPresent()) {
            return new EnvMetadataProvider(config.getEnvironmentVariablePrefix().get());
        }
        return new NoOpMetadataProvider();
    }

    public void publishCompletedEvent(QueryCompletedEvent queryCompletedEvent) {
        this.stats.completedEventReceived();
        String queryId = queryCompletedEvent.getMetadata().getQueryId();
        LOG.debug("preparing to send QueryCompletedEvent for query id: %s", new Object[]{queryId});
        ProducerRecord<String, String> record = null;
        try {
            record = this.kafkaRecordBuilder.buildCompletedRecord(queryCompletedEvent);
        }
        catch (Exception e) {
            this.stats.completedEventBuildFailure();
            LOG.warn((Throwable)e, "unable to build QueryCompletedEvent for query id: %s", new Object[]{queryId});
        }
        if (record != null) {
            this.kafkaProducer.send(record, (metadata, exception) -> {
                if (exception != null) {
                    Exception exception2 = exception;
                    Objects.requireNonNull(exception2);
                    Exception selector0$temp = exception2;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TimeoutException.class, RecordTooLargeException.class, InvalidRecordException.class}, (Exception)selector0$temp, index$1)) {
                        case 0: {
                            TimeoutException e = (TimeoutException)selector0$temp;
                            this.stats.completedEventSendFailureTimeout();
                            break;
                        }
                        case 1: {
                            RecordTooLargeException e = (RecordTooLargeException)selector0$temp;
                            this.stats.completedEventSendFailureTooLarge();
                            break;
                        }
                        case 2: {
                            InvalidRecordException e = (InvalidRecordException)selector0$temp;
                            this.stats.completedEventSendFailureInvalidRecord();
                            break;
                        }
                        default: {
                            this.stats.completedEventSendFailureOther();
                        }
                    }
                    LOG.warn((Throwable)exception, "failed to send QueryCompletedEvent for query id: %s. Uncompressed message size: %s. Partition: %s", new Object[]{queryId, metadata.serializedValueSize(), metadata.partition()});
                } else {
                    this.stats.completedEventSuccessfulDispatch();
                    LOG.debug("successfully sent QueryCompletedEvent for query id: %s", new Object[]{queryId});
                }
            });
        }
    }

    public void publishCreatedEvent(QueryCreatedEvent queryCreatedEvent) {
        this.stats.createdEventReceived();
        String queryId = queryCreatedEvent.getMetadata().getQueryId();
        LOG.debug("preparing to send QueryCreatedEvent for query id: %s", new Object[]{queryId});
        ProducerRecord<String, String> record = null;
        try {
            record = this.kafkaRecordBuilder.buildStartedRecord(queryCreatedEvent);
        }
        catch (Exception e) {
            this.stats.createdEventBuildFailure();
            LOG.warn((Throwable)e, "unable to build QueryCreatedEvent for query id: %s", new Object[]{queryId});
        }
        if (record != null) {
            this.kafkaProducer.send(record, (metadata, exception) -> {
                if (exception != null) {
                    Exception exception2 = exception;
                    Objects.requireNonNull(exception2);
                    Exception selector0$temp = exception2;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TimeoutException.class, RecordTooLargeException.class, InvalidRecordException.class}, (Exception)selector0$temp, index$1)) {
                        case 0: {
                            TimeoutException e = (TimeoutException)selector0$temp;
                            this.stats.createdEventSendFailureTimeout();
                            break;
                        }
                        case 1: {
                            RecordTooLargeException e = (RecordTooLargeException)selector0$temp;
                            this.stats.createdEventSendFailureTooLarge();
                            break;
                        }
                        case 2: {
                            InvalidRecordException e = (InvalidRecordException)selector0$temp;
                            this.stats.createdEventSendFailureInvalidRecord();
                            break;
                        }
                        default: {
                            this.stats.createdEventSendFailureOther();
                        }
                    }
                    LOG.warn((Throwable)exception, "failed to send QueryCreatedEvent for query id: %s. Uncompressed message size: %s. Partition: %s", new Object[]{queryId, metadata.serializedValueSize(), metadata.partition()});
                } else {
                    this.stats.createdEventSuccessfulDispatch();
                    LOG.debug("successfully sent QueryCreatedEvent for query id: %s", new Object[]{queryId});
                }
            });
        }
    }

    public void publishSplitCompletedEvent(SplitCompletedEvent splitCompletedEvent) {
        this.stats.splitCompletedEventReceived();
        String queryId = splitCompletedEvent.getQueryId();
        LOG.debug("preparing to send SplitCompletedEvent for query id: %s", new Object[]{queryId});
        ProducerRecord<String, String> record = null;
        try {
            record = this.kafkaRecordBuilder.buildSplitCompletedRecord(splitCompletedEvent);
        }
        catch (Exception e) {
            this.stats.splitCompletedEventBuildFailure();
            LOG.warn((Throwable)e, "unable to build SplitCompletedEvent for query id: %s", new Object[]{queryId});
        }
        if (record != null) {
            this.kafkaProducer.send(record, (metadata, exception) -> {
                if (exception != null) {
                    Exception exception2 = exception;
                    Objects.requireNonNull(exception2);
                    Exception selector0$temp = exception2;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TimeoutException.class, RecordTooLargeException.class, InvalidRecordException.class}, (Exception)selector0$temp, index$1)) {
                        case 0: {
                            TimeoutException e = (TimeoutException)selector0$temp;
                            this.stats.splitCompletedEventSendFailureTimeout();
                            break;
                        }
                        case 1: {
                            RecordTooLargeException e = (RecordTooLargeException)selector0$temp;
                            this.stats.splitCompletedEventSendFailureTooLarge();
                            break;
                        }
                        case 2: {
                            InvalidRecordException e = (InvalidRecordException)selector0$temp;
                            this.stats.splitCompletedEventSendFailureInvalidRecord();
                            break;
                        }
                        default: {
                            this.stats.splitCompletedEventSendFailureOther();
                        }
                    }
                    LOG.warn((Throwable)exception, "failed to send SplitCompletedEvent for query id: %s. Uncompressed message size: %s. Partition: %s", new Object[]{queryId, metadata.serializedValueSize(), metadata.partition()});
                } else {
                    this.stats.splitCompletedEventSuccessfulDispatch();
                    LOG.debug("successfully sent SplitCompletedEvent for query id: %s", new Object[]{queryId});
                }
            });
        }
    }

    public void shutdown() {
        this.kafkaProducer.close();
    }
}

