/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.kafka;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.eventlistener.kafka.metadata.MetadataProvider;
import io.trino.plugin.eventlistener.kafka.model.QueryCompletedEventWrapper;
import io.trino.plugin.eventlistener.kafka.model.QueryCreatedEventWrapper;
import io.trino.plugin.eventlistener.kafka.model.SplitCompletedEventWrapper;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.SplitCompletedEvent;
import java.util.Set;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaRecordBuilder {
    private final ObjectWriter writer;
    private final String startedTopic;
    private final String completedTopic;
    private final String splitCompletedTopic;
    private final MetadataProvider metadataProvider;

    public KafkaRecordBuilder(String startedTopic, String completedTopic, String splitCompletedTopic, Set<String> excludedFields, MetadataProvider metadataProvider) {
        this.startedTopic = startedTopic;
        this.completedTopic = completedTopic;
        this.splitCompletedTopic = splitCompletedTopic;
        SimpleFilterProvider filter = new SimpleFilterProvider().addFilter("property-name-filter", SimpleBeanPropertyFilter.serializeAllExcept(excludedFields));
        this.writer = new ObjectMapperProvider().get().addMixIn(Object.class, PropertyFilterMixIn.class).writer((FilterProvider)filter);
        this.metadataProvider = metadataProvider;
    }

    public ProducerRecord<String, String> buildStartedRecord(QueryCreatedEvent event) {
        QueryCreatedEventWrapper queryCreatedEvent = new QueryCreatedEventWrapper(event, this.metadataProvider.getMetadata());
        return new ProducerRecord(this.startedTopic, (Object)this.writeJson(queryCreatedEvent));
    }

    public ProducerRecord<String, String> buildCompletedRecord(QueryCompletedEvent event) {
        QueryCompletedEventWrapper queryCompletedEvent = new QueryCompletedEventWrapper(event, this.metadataProvider.getMetadata());
        return new ProducerRecord(this.completedTopic, (Object)this.writeJson(queryCompletedEvent));
    }

    public ProducerRecord<String, String> buildSplitCompletedRecord(SplitCompletedEvent event) {
        SplitCompletedEventWrapper splitCompletedEvent = new SplitCompletedEventWrapper(event, this.metadataProvider.getMetadata());
        return new ProducerRecord(this.splitCompletedTopic, (Object)this.writeJson(splitCompletedEvent));
    }

    private String writeJson(Object payload) {
        try {
            return this.writer.writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonFilter(value="property-name-filter")
    static class PropertyFilterMixIn {
        PropertyFilterMixIn() {
        }
    }
}

