/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.kafka.metadata;

import io.trino.plugin.eventlistener.kafka.metadata.MetadataProvider;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class EnvMetadataProvider
implements MetadataProvider {
    protected final String prefix;

    public EnvMetadataProvider(String prefix) {
        this.prefix = Objects.requireNonNull(prefix, "Prefix must be populated");
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.filter(System.getenv());
    }

    protected Map<String, String> filter(Map<String, String> metadata) {
        return metadata.entrySet().stream().filter((? super T e) -> ((String)e.getKey()).startsWith(this.prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(this.prefix.length()), Map.Entry::getValue));
    }
}

