/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.kafka.producer;

import io.trino.plugin.eventlistener.kafka.KafkaEventListenerConfig;
import io.trino.plugin.eventlistener.kafka.producer.KafkaProducerFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.StringSerializer;

abstract class BaseKafkaProducerFactory
implements KafkaProducerFactory {
    BaseKafkaProducerFactory() {
    }

    @Override
    public Producer<String, String> producer(Map<String, String> overrides) {
        throw new UnsupportedOperationException("Cannot call producer() on abstract class");
    }

    protected Map<String, Object> baseConfig(KafkaEventListenerConfig config) {
        HashMap<String, Object> kafkaClientConfig = new HashMap<String, Object>();
        kafkaClientConfig.put("bootstrap.servers", config.getBrokerEndpoints());
        config.getClientId().ifPresent(clientId -> kafkaClientConfig.put("client.id", clientId));
        kafkaClientConfig.put("key.serializer", StringSerializer.class);
        kafkaClientConfig.put("value.serializer", StringSerializer.class);
        kafkaClientConfig.put("compression.type", "zstd");
        kafkaClientConfig.put("max.request.size", "5242880");
        kafkaClientConfig.put("request.timeout.ms", Long.toString(config.getRequestTimeout().toMillis()));
        return kafkaClientConfig;
    }
}

