/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.kafka.producer;

import com.google.inject.Inject;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.KafkaTelemetry;
import io.trino.plugin.eventlistener.kafka.KafkaEventListenerConfig;
import io.trino.plugin.eventlistener.kafka.producer.BaseKafkaProducerFactory;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;

public class PlaintextKafkaProducerFactory
extends BaseKafkaProducerFactory {
    private final KafkaEventListenerConfig config;
    private final KafkaTelemetry kafkaTelemetry;

    @Inject
    public PlaintextKafkaProducerFactory(KafkaEventListenerConfig config, OpenTelemetry openTelemetry) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.kafkaTelemetry = KafkaTelemetry.builder((OpenTelemetry)Objects.requireNonNull(openTelemetry, "openTelemetry is null")).build();
    }

    @Override
    public Producer<String, String> producer(Map<String, String> overrides) {
        return this.kafkaTelemetry.wrap((Producer)new KafkaProducer(this.createKafkaClientConfig(this.config, overrides)));
    }

    private Map<String, Object> createKafkaClientConfig(KafkaEventListenerConfig config, Map<String, String> kafkaClientOverrides) {
        Map<String, Object> kafkaClientConfig = this.baseConfig(config);
        kafkaClientConfig.putAll(kafkaClientOverrides);
        return kafkaClientConfig;
    }
}

