/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.kafka.producer;

import com.google.inject.Inject;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.KafkaTelemetry;
import io.trino.plugin.eventlistener.kafka.KafkaEventListenerConfig;
import io.trino.plugin.eventlistener.kafka.producer.BaseKafkaProducerFactory;
import io.trino.plugin.kafka.security.KafkaSslConfig;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class SSLKafkaProducerFactory
extends BaseKafkaProducerFactory {
    private final KafkaEventListenerConfig config;
    private final KafkaSslConfig sslConfig;
    private final KafkaTelemetry kafkaTelemetry;

    @Inject
    public SSLKafkaProducerFactory(KafkaEventListenerConfig config, KafkaSslConfig sslConfig, OpenTelemetry openTelemetry) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.sslConfig = sslConfig;
        this.kafkaTelemetry = KafkaTelemetry.builder((OpenTelemetry)Objects.requireNonNull(openTelemetry, "openTelemetry is null")).build();
    }

    @Override
    public Producer<String, String> producer(Map<String, String> overrides) {
        return this.kafkaTelemetry.wrap((Producer)new KafkaProducer(this.createKafkaClientConfig(this.config, this.sslConfig, overrides)));
    }

    private Map<String, Object> createKafkaClientConfig(KafkaEventListenerConfig config, KafkaSslConfig sslConfig, Map<String, String> kafkaClientOverrides) {
        Map<String, Object> kafkaClientConfig = this.baseConfig(config);
        sslConfig.getKeystoreLocation().ifPresent(value -> kafkaClientConfig.put("ssl.keystore.location", value));
        sslConfig.getKeystorePassword().ifPresent(value -> kafkaClientConfig.put("ssl.keystore.password", value));
        sslConfig.getKeystoreType().ifPresent(value -> kafkaClientConfig.put("ssl.keystore.type", value.name()));
        sslConfig.getTruststoreLocation().ifPresent(value -> kafkaClientConfig.put("ssl.truststore.location", value));
        sslConfig.getTruststorePassword().ifPresent(value -> kafkaClientConfig.put("ssl.truststore.password", value));
        sslConfig.getTruststoreType().ifPresent(value -> kafkaClientConfig.put("ssl.truststore.type", value.name()));
        sslConfig.getKeyPassword().ifPresent(value -> kafkaClientConfig.put("ssl.key.password", value));
        sslConfig.getEndpointIdentificationAlgorithm().ifPresent(value -> kafkaClientConfig.put("ssl.endpoint.identification.algorithm", value.getValue()));
        kafkaClientConfig.put("security.protocol", SecurityProtocol.SSL.name());
        kafkaClientConfig.putAll(kafkaClientOverrides);
        return kafkaClientConfig;
    }
}

