/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Objects;

public class ExecuteImmediate
extends Statement {
    private final StringLiteral statement;
    private final List<Expression> parameters;

    public ExecuteImmediate(NodeLocation location, StringLiteral statement, List<Expression> parameters) {
        super(location);
        this.statement = Objects.requireNonNull(statement, "statement is null");
        this.parameters = ImmutableList.copyOf(parameters);
    }

    public StringLiteral getStatement() {
        return this.statement;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExecuteImmediate(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.builder().addAll(this.parameters).add((Object)this.statement).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.statement, this.parameters);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExecuteImmediate o = (ExecuteImmediate)obj;
        return Objects.equals(this.statement, o.statement) && Objects.equals(this.parameters, o.parameters);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statement", (Object)this.statement).add("parameters", this.parameters).toString();
    }
}

