/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import io.trino.metastore.Table;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveMetadata;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.SystemTableHandler;
import io.trino.plugin.hive.SystemTableProvider;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.SystemTables;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.TypeManager;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class PartitionsSystemTableProvider
implements SystemTableProvider {
    private final HivePartitionManager partitionManager;
    private final TypeManager typeManager;

    @Inject
    public PartitionsSystemTableProvider(HivePartitionManager partitionManager, TypeManager typeManager) {
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    public Optional<SchemaTableName> getSourceTableName(SchemaTableName tableName) {
        if (!SystemTableHandler.PARTITIONS.matches(tableName)) {
            return Optional.empty();
        }
        return Optional.of(SystemTableHandler.PARTITIONS.getSourceTableName(tableName));
    }

    @Override
    public Optional<SystemTable> getSystemTable(HiveMetadata metadata, ConnectorSession session, SchemaTableName tableName) {
        if (!SystemTableHandler.PARTITIONS.matches(tableName)) {
            return Optional.empty();
        }
        SchemaTableName sourceTableName = SystemTableHandler.PARTITIONS.getSourceTableName(tableName);
        Table sourceTable = metadata.getMetastore().getTable(sourceTableName.getSchemaName(), sourceTableName.getTableName()).orElse(null);
        if (sourceTable == null || HiveUtil.isDeltaLakeTable(sourceTable) || HiveUtil.isIcebergTable(sourceTable)) {
            return Optional.empty();
        }
        MetastoreUtil.verifyOnline(sourceTableName, Optional.empty(), MetastoreUtil.getProtectMode(sourceTable), sourceTable.getParameters());
        HiveTableHandle sourceTableHandle = new HiveTableHandle(sourceTableName.getSchemaName(), sourceTableName.getTableName(), sourceTable.getParameters(), HiveUtil.getPartitionKeyColumnHandles(sourceTable, this.typeManager), HiveUtil.getRegularColumnHandles(sourceTable, this.typeManager, HiveSessionProperties.getTimestampPrecision(session)), HiveBucketing.getHiveTablePartitioningForRead(session, sourceTable, this.typeManager));
        List<HiveColumnHandle> partitionColumns = sourceTableHandle.getPartitionColumns();
        if (partitionColumns.isEmpty()) {
            return Optional.empty();
        }
        List partitionColumnTypes = (List)partitionColumns.stream().map(HiveColumnHandle::getType).collect(ImmutableList.toImmutableList());
        List partitionSystemTableColumns = (List)partitionColumns.stream().map(column -> ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setComment(column.getComment()).setHidden(column.isHidden()).build()).collect(ImmutableList.toImmutableList());
        return Optional.of(SystemTables.createSystemTable(new ConnectorTableMetadata(tableName, partitionSystemTableColumns), constraint -> {
            Constraint targetConstraint = new Constraint(constraint.transformKeys(partitionColumns::get));
            Iterable records = () -> Streams.stream(this.partitionManager.getPartitions(metadata.getMetastore(), sourceTableHandle, targetConstraint).getPartitions()).map(hivePartition -> partitionColumns.stream().map(columnHandle -> ((NullableValue)hivePartition.getKeys().get(columnHandle)).getValue()).collect(Collectors.toList())).iterator();
            return new InMemoryRecordSet((Collection)partitionColumnTypes, records).cursor();
        }));
    }
}

