/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.acid;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.metastore.AcidOperation;
import java.util.Objects;
import java.util.OptionalLong;

public class AcidTransaction {
    public static final AcidTransaction NO_ACID_TRANSACTION = new AcidTransaction(AcidOperation.NONE, 0L, 0L);
    private final AcidOperation operation;
    private final long transactionId;
    private final long writeId;

    @JsonCreator
    public AcidTransaction(@JsonProperty(value="operation") AcidOperation operation, @JsonProperty(value="transactionId") long transactionId, @JsonProperty(value="writeId") long writeId) {
        this.operation = Objects.requireNonNull(operation, "operation is null");
        this.transactionId = transactionId;
        this.writeId = writeId;
    }

    @JsonProperty
    public AcidOperation getOperation() {
        return this.operation;
    }

    @JsonProperty(value="transactionId")
    public long getAcidTransactionIdForSerialization() {
        return this.transactionId;
    }

    @JsonProperty(value="writeId")
    public long getWriteIdForSerialization() {
        return this.writeId;
    }

    @JsonIgnore
    public boolean isAcidTransactionRunning() {
        return this.operation == AcidOperation.INSERT || this.operation == AcidOperation.CREATE_TABLE || this.operation == AcidOperation.MERGE;
    }

    @JsonIgnore
    public boolean isTransactional() {
        return this.operation != AcidOperation.NONE;
    }

    @JsonIgnore
    public long getAcidTransactionId() {
        this.ensureTransactionRunning("accessing transactionId");
        return this.transactionId;
    }

    @JsonIgnore
    public long getWriteId() {
        this.ensureTransactionRunning("accessing writeId");
        return this.writeId;
    }

    @JsonIgnore
    public OptionalLong getOptionalWriteId() {
        return this.isAcidTransactionRunning() ? OptionalLong.of(this.writeId) : OptionalLong.empty();
    }

    private void ensureTransactionRunning(String description) {
        Preconditions.checkState((boolean)this.isAcidTransactionRunning(), (String)"Not in ACID transaction while %s", (Object)description);
    }

    @JsonIgnore
    public boolean isInsert() {
        return this.operation == AcidOperation.INSERT;
    }

    @JsonIgnore
    public boolean isMerge() {
        return this.operation == AcidOperation.MERGE;
    }

    public static AcidTransaction forCreateTable() {
        return new AcidTransaction(AcidOperation.CREATE_TABLE, 0L, 0L);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operation", (Object)this.operation).add("transactionId", this.transactionId).add("writeId", this.writeId).toString();
    }
}

