/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.VarcharType;
import java.util.Set;

public final class BooleanCoercer {
    private static final Slice TRUE = Slices.utf8Slice((String)"TRUE");
    private static final Slice FALSE = Slices.utf8Slice((String)"FALSE");

    private BooleanCoercer() {
    }

    public static TypeCoercer<VarcharType, BooleanType> createVarcharToBooleanCoercer(VarcharType fromType, boolean isOrcFile) {
        return isOrcFile ? new OrcVarcharToBooleanCoercer(fromType) : new VarcharToBooleanCoercer(fromType);
    }

    public static class OrcVarcharToBooleanCoercer
    extends TypeCoercer<VarcharType, BooleanType> {
        public OrcVarcharToBooleanCoercer(VarcharType fromType) {
            super(fromType, BooleanType.BOOLEAN);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            try {
                ((BooleanType)this.toType).writeBoolean(blockBuilder, Long.parseLong(((VarcharType)this.fromType).getSlice(block, position).toStringUtf8()) != 0L);
            }
            catch (NumberFormatException e) {
                blockBuilder.appendNull();
            }
        }
    }

    public static class VarcharToBooleanCoercer
    extends TypeCoercer<VarcharType, BooleanType> {
        private static final Set<String> FALSE_VALUES = ImmutableSet.of((Object)"false", (Object)"off", (Object)"no", (Object)"0", (Object)"");

        public VarcharToBooleanCoercer(VarcharType fromType) {
            super(fromType, BooleanType.BOOLEAN);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            ((BooleanType)this.toType).writeBoolean(blockBuilder, this.parseBoolean(((VarcharType)this.fromType).getSlice(block, position).toStringUtf8()));
        }

        private boolean parseBoolean(String value) {
            for (String falseValue : FALSE_VALUES) {
                if (!value.equalsIgnoreCase(falseValue)) continue;
                return false;
            }
            return true;
        }
    }

    public static class BooleanToVarcharCoercer
    extends TypeCoercer<BooleanType, VarcharType> {
        public BooleanToVarcharCoercer(VarcharType toType) {
            super(BooleanType.BOOLEAN, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            Slice converted;
            boolean value = BooleanType.BOOLEAN.getBoolean(block, position);
            Slice slice = converted = value ? TRUE : FALSE;
            if (!((VarcharType)this.toType).isUnbounded() && SliceUtf8.countCodePoints((Slice)converted) > ((VarcharType)this.toType).getBoundedLength()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Varchar representation of %s exceeds %s bounds", value, this.toType));
            }
            ((VarcharType)this.toType).writeSlice(blockBuilder, converted);
        }
    }
}

