/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.HexFormat;

public class VarbinaryToVarcharCoercers {
    private VarbinaryToVarcharCoercers() {
    }

    public static TypeCoercer<VarbinaryType, VarcharType> createVarbinaryToVarcharCoercer(VarcharType toType, HiveStorageFormat storageFormat) {
        if (storageFormat == HiveStorageFormat.ORC) {
            return new OrcVarbinaryToVarcharCoercer(toType);
        }
        return new VarbinaryToVarcharCoercer(toType);
    }

    private static class OrcVarbinaryToVarcharCoercer
    extends TypeCoercer<VarbinaryType, VarcharType> {
        private static final HexFormat HEX_FORMAT = HexFormat.of().withDelimiter(" ");

        public OrcVarbinaryToVarcharCoercer(VarcharType toType) {
            super(VarbinaryType.VARBINARY, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            Slice value = ((VarbinaryType)this.fromType).getSlice(block, position);
            Slice hexValue = Slices.utf8Slice((String)HEX_FORMAT.formatHex(value.byteArray(), value.byteArrayOffset(), value.length()));
            if (((VarcharType)this.toType).isUnbounded()) {
                ((VarcharType)this.toType).writeSlice(blockBuilder, hexValue);
                return;
            }
            ((VarcharType)this.toType).writeSlice(blockBuilder, Varchars.truncateToLength((Slice)hexValue, (int)((VarcharType)this.toType).getBoundedLength()));
        }
    }

    private static class VarbinaryToVarcharCoercer
    extends TypeCoercer<VarbinaryType, VarcharType> {
        public VarbinaryToVarcharCoercer(VarcharType toType) {
            super(VarbinaryType.VARBINARY, toType);
        }

        @Override
        protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            try {
                Slice decodedValue = Slices.utf8Slice((String)decoder.decode(((VarbinaryType)this.fromType).getSlice(block, position).toByteBuffer()).toString());
                if (((VarcharType)this.toType).isUnbounded()) {
                    ((VarcharType)this.toType).writeSlice(blockBuilder, decodedValue);
                    return;
                }
                ((VarcharType)this.toType).writeSlice(blockBuilder, Varchars.truncateToLength((Slice)decodedValue, (int)((VarcharType)this.toType).getBoundedLength()));
            }
            catch (CharacterCodingException e) {
                blockBuilder.appendNull();
            }
        }
    }
}

